/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.engine.SourceOfRandomness;
import net.jqwik.engine.properties.shrinking.FixedValueFlatMappedShrinkable;
import net.jqwik.engine.support.JqwikStreamSupport;

public class FlatMappedShrinkable<T, U>
implements Shrinkable<U> {
    private final Shrinkable<T> toMap;
    private final Function<T, Shrinkable<U>> mapper;

    public FlatMappedShrinkable(Shrinkable<T> toMap, Function<T, Arbitrary<U>> toArbitraryMapper, int genSize, long randomSeed, boolean withEmbeddedEdgeCases) {
        this(toMap, t -> {
            Arbitrary arbitrary = (Arbitrary)toArbitraryMapper.apply(t);
            return arbitrary.generator(genSize, withEmbeddedEdgeCases);
        }, randomSeed);
    }

    public FlatMappedShrinkable(Shrinkable<T> toMap, Function<T, RandomGenerator<U>> toGeneratorMapper, long randomSeed) {
        this(toMap, t -> ((RandomGenerator)toGeneratorMapper.apply(t)).next(SourceOfRandomness.newRandom(randomSeed)));
    }

    protected FlatMappedShrinkable(Shrinkable<T> toMap, Function<T, Shrinkable<U>> mapper) {
        this.toMap = toMap;
        this.mapper = mapper;
    }

    private Shrinkable<U> generateShrinkable(T value) {
        return this.mapper.apply(value);
    }

    public Stream<Shrinkable<U>> shrink() {
        return JqwikStreamSupport.concat(this.shrinkRightSide(), this.shrinkLeftSide(), this.shrinkLeftGrowRightSide());
    }

    private Stream<Shrinkable<U>> shrinkRightSide() {
        ShrinkingDistance rightDistance = this.shrinkable().distance();
        return this.shrinkable().shrink().filter(s -> s.distance().size() <= rightDistance.size()).map(rightSide -> new FixedValueFlatMappedShrinkable<T, U>(this.toMap, this.mapper, () -> rightSide));
    }

    private Stream<Shrinkable<U>> shrinkLeftSide() {
        return this.toMap.shrink().map(shrunkLeftSide -> new FlatMappedShrinkable<T, U>(shrunkLeftSide, this.mapper));
    }

    private Stream<Shrinkable<U>> growRightSide() {
        return this.shrinkable().grow().map(rightSide -> new FixedValueFlatMappedShrinkable<T, U>(this.toMap, this.mapper, () -> rightSide));
    }

    private Stream<Shrinkable<U>> shrinkLeftGrowRightSide() {
        return this.toMap.shrink().map(shrunkLeftSide -> new FlatMappedShrinkable<T, U>(shrunkLeftSide, this.mapper)).flatMap(FlatMappedShrinkable::growRightSide);
    }

    public U value() {
        return (U)this.shrinkable().value();
    }

    protected Shrinkable<U> shrinkable() {
        return this.generateShrinkable(this.toMap.value());
    }

    public ShrinkingDistance distance() {
        return this.toMap.distance().append(this.shrinkable().distance());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FlatMappedShrinkable)) {
            return false;
        }
        FlatMappedShrinkable that = (FlatMappedShrinkable)o;
        return Objects.equals(this.value(), that.value());
    }

    public int hashCode() {
        return Objects.hash(this.value());
    }

    public String toString() {
        return String.format("%s<%s>(%s:%s)|%s", this.getClass().getSimpleName(), this.value().getClass().getSimpleName(), this.value(), this.distance(), this.toMap);
    }
}

