/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.support;

import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.support.GenericsClassContext;

public class GenericsSupport {
    private static Map<TypeUsage, GenericsClassContext> contextsCache = new HashMap<TypeUsage, GenericsClassContext>();

    public static synchronized GenericsClassContext contextFor(Class<?> contextClass) {
        if (contextClass == null) {
            return GenericsClassContext.NULL;
        }
        return GenericsSupport.contextFor(TypeUsage.of(contextClass, (TypeUsage[])new TypeUsage[0]));
    }

    public static synchronized GenericsClassContext contextFor(TypeUsage typeUsage) {
        return contextsCache.computeIfAbsent(typeUsage, GenericsSupport::createContext);
    }

    private static GenericsClassContext createContext(TypeUsage typeUsage) {
        GenericsClassContext context = new GenericsClassContext(typeUsage);
        GenericsSupport.addOwnResolutions(typeUsage, context);
        GenericsSupport.addResolutionsForSuperclass(typeUsage, context);
        GenericsSupport.addResolutionsForInterfaces(typeUsage, context);
        return context;
    }

    private static void addResolutionsForInterfaces(TypeUsage contextType, GenericsClassContext context) {
        Class<?>[] interfaces = contextType.getRawType().getInterfaces();
        Type[] genericInterfaces = contextType.getRawType().getGenericInterfaces();
        AnnotatedType[] annotatedInterfaces = contextType.getRawType().getAnnotatedInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> supertype = interfaces[i];
            Type genericSupertype = genericInterfaces[i];
            AnnotatedType annotatedSupertype = annotatedInterfaces[i];
            GenericsSupport.addResolutionsForSupertype(supertype, genericSupertype, annotatedSupertype, context);
        }
    }

    private static void addResolutionsForSuperclass(TypeUsage typeUsage, GenericsClassContext context) {
        GenericsSupport.addResolutionsForSupertype(typeUsage.getRawType().getSuperclass(), typeUsage.getRawType().getGenericSuperclass(), typeUsage.getRawType().getAnnotatedSuperclass(), context);
    }

    private static void addOwnResolutions(TypeUsage typeUsage, GenericsClassContext context) {
        if (typeUsage.getTypeArguments().isEmpty()) {
            return;
        }
        List typeArgumentsList = typeUsage.getTypeArguments();
        Type[] typeArguments = new Type[typeArgumentsList.size()];
        AnnotatedType[] annotatedTypeVariables = new AnnotatedType[typeArgumentsList.size()];
        for (int i = 0; i < typeArgumentsList.size(); ++i) {
            typeArguments[i] = ((TypeUsage)typeArgumentsList.get(i)).getType();
            annotatedTypeVariables[i] = ((TypeUsage)typeArgumentsList.get(i)).getAnnotatedType();
        }
        TypeVariable[] typeVariables = typeUsage.getRawType().getTypeParameters();
        GenericsSupport.addResolutions(context, typeArguments, typeVariables, annotatedTypeVariables);
    }

    private static void addResolutionsForSupertype(Class<?> supertype, Type genericSupertype, AnnotatedType annotatedSupertype, GenericsClassContext context) {
        if (!(genericSupertype instanceof ParameterizedType)) {
            return;
        }
        ParameterizedType genericParameterizedType = (ParameterizedType)genericSupertype;
        Type[] typeArguments = genericParameterizedType.getActualTypeArguments();
        TypeVariable[] typeVariables = supertype.getTypeParameters();
        AnnotatedType[] annotatedTypeVariables = ((AnnotatedParameterizedType)annotatedSupertype).getAnnotatedActualTypeArguments();
        GenericsSupport.addResolutions(context, typeArguments, typeVariables, annotatedTypeVariables);
    }

    private static void addResolutions(GenericsClassContext context, Type[] typeArguments, TypeVariable[] typeVariables, AnnotatedType[] annotatedTypeVariables) {
        for (int i = 0; i < typeVariables.length; ++i) {
            TypeVariable variable = typeVariables[i];
            Type resolvedType = typeArguments[i];
            AnnotatedType annotatedType = annotatedTypeVariables[i];
            context.addResolution(variable, resolvedType, annotatedType);
        }
    }
}

