/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jqwik.api.AfterFailureMode;
import net.jqwik.api.EdgeCasesMode;
import net.jqwik.api.FixedSeedMode;
import net.jqwik.api.GenerationMode;
import net.jqwik.api.JqwikException;
import net.jqwik.api.ShrinkingMode;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.support.config.PrefixedConfigurationParameters;

public class JqwikProperties {
    public static final int DEFAULT_TRIES = 1000;
    private static final Map<String, String> COMPATIBILITY_PROPERTY_NAMES;
    private static final String PROPERTIES_FILE_NAME = "jqwik.properties";
    private static final String CONFIGURATION_PARAMETERS_PREFIX = "jqwik.";
    private static final Logger LOG;
    private static final String DEFAULT_DATABASE_PATH = ".jqwik-database";
    private static final boolean DEFAULT_RERUN_FAILURES_FIRST = false;
    private static final int DEFAULT_MAX_DISCARD_RATIO = 5;
    private static final AfterFailureMode DEFAULT_AFTER_FAILURE;
    private static final boolean DEFAULT_REPORT_ONLY_FAILURES = false;
    private static final GenerationMode DEFAULT_GENERATION;
    private static final EdgeCasesMode DEFAULT_EDGE_CASES;
    private static final ShrinkingMode DEFAULT_SHRINKING;
    private static final int DEFAULT_BOUNDED_SHRINKING_SECONDS = 10;
    private static final boolean DEFAULT_USE_JUNIT_PLATFORM_REPORTER = false;
    private final String databasePath;
    private final boolean runFailuresFirst;
    private final int defaultTries;
    private final int defaultMaxDiscardRatio;
    private final boolean useJunitPlatformReporter;
    private final AfterFailureMode defaultAfterFailure;
    private final boolean reportOnlyFailures;
    private final GenerationMode defaultGeneration;
    private final EdgeCasesMode defaultEdgeCases;
    private final ShrinkingMode defaultShrinking;
    private final int boundedShrinkingSeconds;
    private final FixedSeedMode fixedSeedMode;

    public String databasePath() {
        return this.databasePath;
    }

    public boolean runFailuresFirst() {
        return this.runFailuresFirst;
    }

    public int defaultTries() {
        return this.defaultTries;
    }

    public int defaultMaxDiscardRatio() {
        return this.defaultMaxDiscardRatio;
    }

    public boolean useJunitPlatformReporter() {
        return this.useJunitPlatformReporter;
    }

    public AfterFailureMode defaultAfterFailure() {
        return this.defaultAfterFailure;
    }

    public boolean reportOnlyFailures() {
        return this.reportOnlyFailures;
    }

    public GenerationMode defaultGeneration() {
        return this.defaultGeneration;
    }

    public EdgeCasesMode defaultEdgeCases() {
        return this.defaultEdgeCases;
    }

    public ShrinkingMode defaultShrinking() {
        return this.defaultShrinking;
    }

    public int boundedShrinkingSeconds() {
        return this.boundedShrinkingSeconds;
    }

    public FixedSeedMode fixedSeedMode() {
        return this.fixedSeedMode;
    }

    JqwikProperties(ConfigurationParameters parameters) {
        this.databasePath = parameters.get("database").orElse(DEFAULT_DATABASE_PATH);
        this.runFailuresFirst = parameters.getBoolean("failures.runfirst").orElse(false);
        this.defaultTries = parameters.get("tries.default", Integer::parseInt).orElse(1000);
        this.defaultMaxDiscardRatio = parameters.get("maxdiscardratio.default", Integer::parseInt).orElse(5);
        this.useJunitPlatformReporter = parameters.getBoolean("reporting.usejunitplatform").orElse(false);
        this.defaultAfterFailure = parameters.get("failures.after.default", AfterFailureMode::valueOf).orElse(DEFAULT_AFTER_FAILURE);
        this.reportOnlyFailures = parameters.getBoolean("reporting.onlyfailures").orElse(false);
        this.defaultGeneration = parameters.get("generation.default", GenerationMode::valueOf).orElse(DEFAULT_GENERATION);
        this.defaultEdgeCases = parameters.get("edgecases.default", EdgeCasesMode::valueOf).orElse(DEFAULT_EDGE_CASES);
        this.defaultShrinking = parameters.get("shrinking.default", ShrinkingMode::valueOf).orElse(DEFAULT_SHRINKING);
        this.boundedShrinkingSeconds = parameters.get("shrinking.bounded.seconds", Integer::parseInt).orElse(10);
        this.fixedSeedMode = parameters.get("seeds.whenfixed", FixedSeedMode::valueOf).orElse(FixedSeedMode.ALLOW);
    }

    static JqwikProperties loadWithBackwardsCompatibility(ConfigurationParameters fromJunit) {
        PrefixedConfigurationParameters fromJunitPrefixed = new PrefixedConfigurationParameters(fromJunit, CONFIGURATION_PARAMETERS_PREFIX);
        JqwikPropertiesFileConfigurationParameters fromJqwikProperties = new JqwikPropertiesFileConfigurationParameters();
        return new JqwikProperties(new CompatibilityConfigurationParameters((ConfigurationParameters)fromJunitPrefixed, fromJunit, fromJqwikProperties));
    }

    static {
        HashMap<String, String> priorNames = new HashMap<String, String>();
        priorNames.put("database", "database");
        priorNames.put("failures.runfirst", "runFailuresFirst");
        priorNames.put("tries.default", "defaultTries");
        priorNames.put("maxdiscardratio.default", "defaultMaxDiscardRatio");
        priorNames.put("reporting.usejunitplatform", "useJunitPlatformReporter");
        priorNames.put("failures.after.default", "defaultAfterFailure");
        priorNames.put("reporting.onlyfailures", "reportOnlyFailures");
        priorNames.put("generation.default", "defaultGeneration");
        priorNames.put("edgecases.default", "defaultEdgeCases");
        priorNames.put("shrinking.default", "defaultShrinking");
        priorNames.put("shrinking.bounded.seconds", "boundedShrinkingSeconds");
        COMPATIBILITY_PROPERTY_NAMES = Collections.unmodifiableMap(priorNames);
        LOG = Logger.getLogger(JqwikProperties.class.getName());
        DEFAULT_AFTER_FAILURE = AfterFailureMode.PREVIOUS_SEED;
        DEFAULT_GENERATION = GenerationMode.AUTO;
        DEFAULT_EDGE_CASES = EdgeCasesMode.MIXIN;
        DEFAULT_SHRINKING = ShrinkingMode.BOUNDED;
    }

    private static class JqwikPropertiesFileConfigurationParameters
    implements ConfigurationParameters {
        private final Properties properties = new Properties();

        JqwikPropertiesFileConfigurationParameters() {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(JqwikProperties.PROPERTIES_FILE_NAME);
            if (inputStream != null) {
                try {
                    this.properties.load(inputStream);
                }
                catch (Throwable throwable) {
                    String message = String.format("Error while reading properties file [%s]", JqwikProperties.PROPERTIES_FILE_NAME);
                    throw new JqwikException(message, throwable);
                }
                this.warnOnUnsupportedProperties();
            }
        }

        private void warnOnUnsupportedProperties() {
            for (String propertyName : this.properties.stringPropertyNames()) {
                if (COMPATIBILITY_PROPERTY_NAMES.containsValue(propertyName)) continue;
                String message = String.format("Property [%s] is not supported in '%s' file", propertyName, JqwikProperties.PROPERTIES_FILE_NAME);
                LOG.log(Level.WARNING, message);
            }
        }

        public Optional<String> get(String key) {
            return Optional.ofNullable(this.properties.getProperty(key));
        }

        public Optional<Boolean> getBoolean(String key) {
            return this.get(key, Boolean::parseBoolean);
        }

        public int size() {
            return this.properties.size();
        }
    }

    private static class CompatibilityConfigurationParameters
    implements ConfigurationParameters {
        private final ConfigurationParameters fromJunitPrefixed;
        private final ConfigurationParameters fromJunitUnPrefixed;
        private final ConfigurationParameters fromJqwikProperties;

        private CompatibilityConfigurationParameters(ConfigurationParameters fromJunitPrefixed, ConfigurationParameters fromJunit, ConfigurationParameters fromJqwikProperties) {
            this.fromJunitPrefixed = fromJunitPrefixed;
            this.fromJunitUnPrefixed = fromJunit;
            this.fromJqwikProperties = fromJqwikProperties;
        }

        public Optional<String> get(String key) {
            return this.get(key, Function.identity());
        }

        public Optional<Boolean> getBoolean(String key) {
            return this.get(key, Boolean::parseBoolean);
        }

        public int size() {
            throw new UnsupportedOperationException();
        }

        public <T> Optional<T> get(String key, Function<String, T> transformer) {
            Optional value = this.fromJunitPrefixed.get(key, transformer);
            Optional<String> priorName = Optional.ofNullable((String)COMPATIBILITY_PROPERTY_NAMES.get(key));
            if (value.isPresent()) {
                priorName.ifPresent(compatibilityKey -> this.complainIfAlsoSpecifiedInCompatibilityParameters(key, (String)compatibilityKey));
                return value;
            }
            return priorName.flatMap(compatibilityKey -> this.compatibilityGet(key, (String)compatibilityKey, transformer));
        }

        private <T> Optional<T> compatibilityGet(String key, String compatibilityKey, Function<String, T> transformer) {
            Optional valueUnderCompatibilityKey = this.fromJunitUnPrefixed.get(compatibilityKey, transformer);
            if (valueUnderCompatibilityKey.isPresent()) {
                LOG.log(Level.SEVERE, String.format("Property [%s] is using compatibility key name. Rename to [%s] to eliminate this message.", compatibilityKey, key));
                this.complainIfAlsoSpecifiedInCompatibilityParameters(compatibilityKey, compatibilityKey);
                return valueUnderCompatibilityKey;
            }
            Optional compatibilityValue = this.fromJqwikProperties.get(compatibilityKey, transformer);
            if (compatibilityValue.isPresent()) {
                LOG.log(Level.WARNING, String.format("Loaded property [%s] from [%s]. Move to [junit-platform.properties] as [%s] to eliminate this message.", compatibilityKey, JqwikProperties.PROPERTIES_FILE_NAME, key));
            }
            return compatibilityValue;
        }

        private void complainIfAlsoSpecifiedInCompatibilityParameters(String key, String compatibilityKey) {
            this.fromJqwikProperties.get(compatibilityKey).ifPresent(v -> LOG.log(Level.SEVERE, String.format("Loaded property [%s] from JUnit Configuration. Ignoring value for [%s] found in [%s]. Remove to eliminate this message.", key, compatibilityKey, JqwikProperties.PROPERTIES_FILE_NAME)));
        }
    }
}

