/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.jqwik.api.Reporter;
import net.jqwik.api.lifecycle.LifecycleContext;
import net.jqwik.engine.descriptor.ContainerClassDescriptor;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.engine.TestDescriptor;

abstract class AbstractLifecycleContext
implements LifecycleContext {
    private Reporter reporter;
    private final TestDescriptor self;

    protected AbstractLifecycleContext(Reporter reporter, TestDescriptor self) {
        this.reporter = reporter;
        this.self = self;
    }

    public Reporter reporter() {
        return this.reporter;
    }

    public void wrapReporter(Function<Reporter, Reporter> wrapper) {
        this.reporter = wrapper.apply(this.reporter);
    }

    public String label() {
        return this.self.getDisplayName();
    }

    public <T extends Annotation> Optional<T> findAnnotation(Class<T> annotationClass) {
        return this.optionalElement().flatMap(element -> AnnotationSupport.findAnnotation((AnnotatedElement)element, (Class)annotationClass));
    }

    public <T extends Annotation> List<T> findAnnotationsInContainer(Class<T> annotationClass) {
        return this.optionalElement().map(element -> {
            ArrayList annotations = new ArrayList();
            this.appendAnnotations(this.parentContainer(), annotationClass, annotations);
            return annotations;
        }).orElse(Collections.emptyList());
    }

    private Optional<ContainerClassDescriptor> parentContainer() {
        return this.parentContainer(this.self);
    }

    private Optional<ContainerClassDescriptor> parentContainer(TestDescriptor descriptor) {
        return descriptor.getParent().filter(parent -> parent instanceof ContainerClassDescriptor).map(parent -> (ContainerClassDescriptor)parent);
    }

    private <T extends Annotation> void appendAnnotations(Optional<ContainerClassDescriptor> optionalContainer, Class<T> annotationClass, List<T> annotations) {
        optionalContainer.ifPresent(container -> {
            AnnotationSupport.findAnnotation(container.getContainerClass(), (Class)annotationClass).ifPresent(annotations::add);
            this.appendAnnotations(this.parentContainer((TestDescriptor)container), annotationClass, annotations);
        });
    }
}

