/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution.lifecycle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.JqwikException;
import net.jqwik.api.lifecycle.Lifespan;
import net.jqwik.api.lifecycle.Store;
import net.jqwik.engine.execution.lifecycle.ScopedStore;
import org.junit.platform.engine.TestDescriptor;

public class StoreRepository {
    private static StoreRepository current;
    private final Map<Object, IdentifiedStores> storesByIdentifier = new HashMap<Object, IdentifiedStores>();

    public static synchronized StoreRepository getCurrent() {
        if (current == null) {
            current = new StoreRepository();
        }
        return current;
    }

    public <T> ScopedStore<T> create(TestDescriptor scope, Object identifier, Lifespan lifespan, Supplier<T> initializer) {
        if (scope == null) {
            throw new IllegalArgumentException("scope must not be null");
        }
        if (initializer == null) {
            throw new IllegalArgumentException("initializer must not be null");
        }
        if (lifespan == null) {
            throw new IllegalArgumentException("lifespan must not be null");
        }
        if (identifier == null) {
            throw new IllegalArgumentException("identifier must not be null");
        }
        ScopedStore<T> store = new ScopedStore<T>(identifier, lifespan, scope, initializer);
        this.addStore(identifier, store);
        return store;
    }

    private <T> void addStore(Object identifier, ScopedStore<T> newStore) {
        IdentifiedStores identifiedStores = this.storesByIdentifier.computeIfAbsent(newStore.getIdentifier(), ignore -> new IdentifiedStores());
        Optional<ScopedStore> conflictingStore = identifiedStores.values().stream().filter(store -> this.isVisibleInAncestorOrDescendant(newStore, (ScopedStore<?>)store)).findFirst();
        conflictingStore.ifPresent(existingStore -> {
            String message = String.format("You cannot create %s with identifier [%s]. It conflicts with existing %s", newStore, identifier.toString(), conflictingStore);
            throw new JqwikException(message);
        });
        identifiedStores.put(newStore.getScope(), newStore);
        this.storesByIdentifier.put(identifier, identifiedStores);
    }

    private <T> boolean isVisibleInAncestorOrDescendant(ScopedStore<T> newStore, ScopedStore<?> store) {
        return store.isVisibleFor(newStore.getScope()) || newStore.isVisibleFor(store.getScope());
    }

    public <T> Optional<ScopedStore<T>> get(TestDescriptor retriever, Object identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("identifier must not be null");
        }
        IdentifiedStores identifiedStores = this.storesByIdentifier.get(identifier);
        if (identifiedStores == null) {
            return Optional.empty();
        }
        return identifiedStores.values().stream().filter(store -> store.isVisibleFor(retriever)).map(store -> store).findFirst();
    }

    public void finishScope(TestDescriptor scope) {
        List storesToRemove = this.streamAllStores().filter(store -> this.isStoreIn((ScopedStore<?>)store, scope)).collect(Collectors.toList());
        for (ScopedStore store2 : storesToRemove) {
            store2.close();
            this.storesByIdentifier.get(store2.getIdentifier()).remove(store2.getScope());
        }
    }

    private Stream<ScopedStore<?>> streamAllStores() {
        ArrayList<IdentifiedStores> values = new ArrayList<IdentifiedStores>(this.storesByIdentifier.values());
        return values.stream().flatMap(identifiedStores -> new ArrayList(identifiedStores.values()).stream());
    }

    private boolean isStoreIn(ScopedStore<?> store, TestDescriptor scope) {
        return store.getScope().equals(scope) || scope.getDescendants().contains(store.getScope());
    }

    public void finishProperty(TestDescriptor scope) {
        this.streamAllStores().filter(store -> store.lifespan() == Lifespan.PROPERTY).filter(store -> store.isVisibleFor(scope)).forEach(Store::reset);
    }

    public void finishTry(TestDescriptor scope) {
        this.streamAllStores().filter(store -> store.lifespan() == Lifespan.TRY).filter(store -> store.isVisibleFor(scope)).forEach(Store::reset);
    }

    private static class IdentifiedStores
    extends HashMap<TestDescriptor, ScopedStore<?>> {
        private IdentifiedStores() {
        }
    }
}

