/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.facades;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.RandomGenerator;
import net.jqwik.engine.SourceOfRandomness;
import net.jqwik.engine.execution.lifecycle.CurrentTestDescriptor;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;

class SampleStreamFacade {
    private static final TestDescriptor SAMPLE_STREAM_DESCRIPTOR = new AbstractTestDescriptor(UniqueId.root((String)"jqwik", (String)"samples"), "Streaming samples outside jqwik thread"){

        public TestDescriptor.Type getType() {
            return TestDescriptor.Type.TEST;
        }
    };
    private static final Map<Arbitrary<Object>, RandomGenerator<Object>> generators = new HashMap<Arbitrary<Object>, RandomGenerator<Object>>();

    SampleStreamFacade() {
    }

    private static <T> RandomGenerator<T> getGeneratorForSampling(Arbitrary<T> arbitrary) {
        return SampleStreamFacade.runInDescriptor(() -> SampleStreamFacade.getGenerator((Arbitrary<Object>)arbitrary));
    }

    private static <T> RandomGenerator<T> getGenerator(Arbitrary<Object> arbitrary) {
        RandomGenerator generator = generators.get(arbitrary);
        if (generator == null) {
            generator = arbitrary.generator(1000, true);
            generators.put(arbitrary, (RandomGenerator<Object>)generator);
        }
        return generator;
    }

    private static <T> Supplier<T> wrapInDescriptor(Supplier<T> code) {
        return () -> CurrentTestDescriptor.runWithDescriptor(SAMPLE_STREAM_DESCRIPTOR, code);
    }

    private static <T> T runInDescriptor(Supplier<T> code) {
        if (CurrentTestDescriptor.isEmpty()) {
            return CurrentTestDescriptor.runWithDescriptor(SAMPLE_STREAM_DESCRIPTOR, code);
        }
        return code.get();
    }

    <T> Stream<T> sampleStream(Arbitrary<T> arbitrary) {
        RandomGenerator generator = SampleStreamFacade.getGeneratorForSampling(arbitrary);
        return Stream.generate(SampleStreamFacade.wrapInDescriptor(() -> generator.next(SourceOfRandomness.current()))).map(shrinkable -> SampleStreamFacade.runInDescriptor(() -> shrinkable.value()));
    }
}

