/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.math.BigDecimal;
import java.util.Optional;
import java.util.function.Consumer;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.arbitraries.BigDecimalArbitrary;
import net.jqwik.engine.properties.Range;
import net.jqwik.engine.properties.arbitraries.DecimalGeneratingArbitrary;
import net.jqwik.engine.properties.arbitraries.TypedCloneable;

public class DefaultBigDecimalArbitrary
extends TypedCloneable
implements BigDecimalArbitrary {
    public static final BigDecimal DEFAULT_MIN = BigDecimal.valueOf(-1.7976931348623157E308);
    public static final BigDecimal DEFAULT_MAX = BigDecimal.valueOf(Double.MAX_VALUE);
    private static final Range<BigDecimal> DEFAULT_RANGE = Range.of(DEFAULT_MIN, DEFAULT_MAX);
    private DecimalGeneratingArbitrary generatingArbitrary = new DecimalGeneratingArbitrary(DEFAULT_RANGE);

    public RandomGenerator<BigDecimal> generator(int genSize) {
        return this.generatingArbitrary.generator(genSize);
    }

    public Optional<ExhaustiveGenerator<BigDecimal>> exhaustive(long maxNumberOfSamples) {
        return this.generatingArbitrary.exhaustive(maxNumberOfSamples);
    }

    public EdgeCases<BigDecimal> edgeCases(int maxEdgeCases) {
        return this.generatingArbitrary.edgeCases(maxEdgeCases);
    }

    public Arbitrary<BigDecimal> edgeCases(Consumer<EdgeCases.Config<BigDecimal>> configurator) {
        DefaultBigDecimalArbitrary clone = (DefaultBigDecimalArbitrary)this.typedClone();
        clone.generatingArbitrary = (DecimalGeneratingArbitrary)this.generatingArbitrary.edgeCases(configurator);
        return clone;
    }

    public BigDecimalArbitrary withDistribution(RandomDistribution distribution) {
        DefaultBigDecimalArbitrary clone = (DefaultBigDecimalArbitrary)this.typedClone();
        clone.generatingArbitrary.distribution = distribution;
        return clone;
    }

    public BigDecimalArbitrary between(BigDecimal min, boolean minIncluded, BigDecimal max, boolean maxIncluded) {
        min = min == null ? DEFAULT_MIN : min;
        max = max == null ? DEFAULT_MAX : max;
        DefaultBigDecimalArbitrary clone = (DefaultBigDecimalArbitrary)this.typedClone();
        clone.generatingArbitrary.range = Range.of(min, minIncluded, max, maxIncluded);
        return clone;
    }

    public BigDecimalArbitrary lessThan(BigDecimal max) {
        return this.between((BigDecimal)this.generatingArbitrary.range.min, this.generatingArbitrary.range.minIncluded, max, false);
    }

    public BigDecimalArbitrary lessOrEqual(BigDecimal max) {
        return this.between((BigDecimal)this.generatingArbitrary.range.min, this.generatingArbitrary.range.minIncluded, max, true);
    }

    public BigDecimalArbitrary greaterOrEqual(BigDecimal min) {
        return this.between(min, true, (BigDecimal)this.generatingArbitrary.range.max, this.generatingArbitrary.range.maxIncluded);
    }

    public BigDecimalArbitrary greaterThan(BigDecimal min) {
        return this.between(min, false, (BigDecimal)this.generatingArbitrary.range.max, this.generatingArbitrary.range.maxIncluded);
    }

    public BigDecimalArbitrary ofScale(int scale) {
        DefaultBigDecimalArbitrary clone = (DefaultBigDecimalArbitrary)this.typedClone();
        clone.generatingArbitrary.scale = scale;
        return clone;
    }

    public BigDecimalArbitrary shrinkTowards(BigDecimal target) {
        DefaultBigDecimalArbitrary clone = (DefaultBigDecimalArbitrary)this.typedClone();
        clone.generatingArbitrary.shrinkingTarget = target;
        return clone;
    }
}

