/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.TooManyFilterMissesException;
import net.jqwik.api.Tuple;
import net.jqwik.engine.properties.MaxTriesLoop;
import net.jqwik.engine.properties.shrinking.FilteredShrinkable;

public class FilteredGenerator<T>
implements RandomGenerator<T> {
    private final RandomGenerator<T> toFilter;
    private final Predicate<T> filterPredicate;

    public FilteredGenerator(RandomGenerator<T> toFilter, Predicate<T> filterPredicate) {
        this.toFilter = toFilter;
        this.filterPredicate = filterPredicate;
    }

    public Shrinkable<T> next(Random random) {
        return this.nextUntilAccepted(random, arg_0 -> this.toFilter.next(arg_0));
    }

    public String toString() {
        return String.format("Filtering [%s]", this.toFilter);
    }

    private Shrinkable<T> nextUntilAccepted(Random random, Function<Random, Shrinkable<T>> fetchShrinkable) {
        Shrinkable accepted = MaxTriesLoop.loop(() -> true, next -> {
            next = (Shrinkable)fetchShrinkable.apply(random);
            if (this.filterPredicate.test(next.value())) {
                return Tuple.of((Object)true, (Object)next);
            }
            return Tuple.of((Object)false, (Object)next);
        }, maxMisses -> {
            String message = String.format("%s missed more than %s times.", this.toString(), maxMisses);
            return new TooManyFilterMissesException(message);
        });
        return new FilteredShrinkable<T>(accepted, this.filterPredicate);
    }
}

