/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.discovery;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Predicate;
import net.jqwik.engine.PropertyAttributesDefaults;
import net.jqwik.engine.discovery.ElementResolver;
import net.jqwik.engine.discovery.GroupContainerResolver;
import net.jqwik.engine.discovery.HierarchicalJavaResolver;
import net.jqwik.engine.discovery.JqwikKotlinSupport;
import net.jqwik.engine.discovery.PropertyMethodResolver;
import net.jqwik.engine.discovery.TopLevelContainerResolver;
import net.jqwik.engine.discovery.predicates.IsScannableContainerClass;
import net.jqwik.engine.recording.TestRunData;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.EngineDiscoveryListener;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.ModuleSelector;
import org.junit.platform.engine.discovery.PackageNameFilter;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;

public class JqwikDiscoverer {
    private static final IsScannableContainerClass isScannableTestClass = new IsScannableContainerClass();
    private final TestRunData testRunData;
    private final PropertyAttributesDefaults propertyDefaultValues;

    public JqwikDiscoverer(TestRunData testRunData, PropertyAttributesDefaults propertyDefaultValues) {
        this.testRunData = testRunData;
        this.propertyDefaultValues = propertyDefaultValues;
    }

    public void discover(EngineDiscoveryRequest request, TestDescriptor engineDescriptor) {
        HierarchicalJavaResolver javaElementsResolver = this.createHierarchicalResolver(engineDescriptor);
        EngineDiscoveryListener discoveryListener = request.getDiscoveryListener();
        Predicate<String> classNamePredicate = JqwikDiscoverer.buildClassNamePredicate(request);
        request.getSelectorsByType(ModuleSelector.class).forEach(selector -> ReflectionSupport.findAllClassesInModule((String)selector.getModuleName(), (Predicate)isScannableTestClass, (Predicate)classNamePredicate).forEach(testClass -> discoveryListener.selectorProcessed(engineDescriptor.getUniqueId(), (DiscoverySelector)selector, javaElementsResolver.resolveClass((Class<?>)testClass))));
        request.getSelectorsByType(ClasspathRootSelector.class).forEach(selector -> ReflectionSupport.findAllClassesInClasspathRoot((URI)selector.getClasspathRoot(), (Predicate)isScannableTestClass, (Predicate)classNamePredicate).forEach(testClass -> discoveryListener.selectorProcessed(engineDescriptor.getUniqueId(), (DiscoverySelector)selector, javaElementsResolver.resolveClass((Class<?>)testClass))));
        request.getSelectorsByType(PackageSelector.class).forEach(selector -> ReflectionSupport.findAllClassesInPackage((String)selector.getPackageName(), (Predicate)isScannableTestClass, (Predicate)classNamePredicate).forEach(testClass -> discoveryListener.selectorProcessed(engineDescriptor.getUniqueId(), (DiscoverySelector)selector, javaElementsResolver.resolveClass((Class<?>)testClass))));
        request.getSelectorsByType(ClassSelector.class).forEach(selector -> discoveryListener.selectorProcessed(engineDescriptor.getUniqueId(), (DiscoverySelector)selector, javaElementsResolver.resolveClass(selector.getJavaClass())));
        request.getSelectorsByType(MethodSelector.class).forEach(selector -> {
            Method javaMethod = this.getJavaMethodWithSpecialKotlinHandling((MethodSelector)selector);
            discoveryListener.selectorProcessed(engineDescriptor.getUniqueId(), (DiscoverySelector)selector, javaElementsResolver.resolveMethod(selector.getJavaClass(), javaMethod));
        });
        request.getSelectorsByType(UniqueIdSelector.class).forEach(selector -> discoveryListener.selectorProcessed(engineDescriptor.getUniqueId(), (DiscoverySelector)selector, javaElementsResolver.resolveUniqueId(selector.getUniqueId())));
    }

    private Method getJavaMethodWithSpecialKotlinHandling(MethodSelector selector) {
        try {
            return selector.getJavaMethod();
        }
        catch (Exception methodNotFound) {
            String methodName = selector.getMethodName();
            for (Method method : selector.getJavaClass().getMethods()) {
                if (this.matchesSpecialKotlinMethod(method, methodName)) {
                    return method;
                }
                if (!this.matchesInternalKotlinMethod(method, methodName)) continue;
                return method;
            }
            throw methodNotFound;
        }
    }

    private boolean matchesSpecialKotlinMethod(Method method, String methodName) {
        if (JqwikKotlinSupport.isSpeciallyNamedKotlinMethod(method)) {
            return methodName.equals(JqwikKotlinSupport.nameWithoutSpecialPart(method));
        }
        return false;
    }

    private boolean matchesInternalKotlinMethod(Method method, String methodName) {
        if (!JqwikKotlinSupport.isInternalKotlinMethod(method)) {
            return false;
        }
        return methodName.equals(JqwikKotlinSupport.nameWithoutInternalPart(method));
    }

    private HierarchicalJavaResolver createHierarchicalResolver(TestDescriptor engineDescriptor) {
        HashSet<ElementResolver> resolvers = new HashSet<ElementResolver>();
        resolvers.add(new TopLevelContainerResolver());
        resolvers.add(new GroupContainerResolver());
        resolvers.add(new PropertyMethodResolver(this.testRunData, this.propertyDefaultValues));
        return new HierarchicalJavaResolver(engineDescriptor, resolvers);
    }

    private static Predicate<String> buildClassNamePredicate(EngineDiscoveryRequest request) {
        ArrayList filters = new ArrayList();
        filters.addAll(request.getFiltersByType(ClassNameFilter.class));
        filters.addAll(request.getFiltersByType(PackageNameFilter.class));
        return Filter.composeFilters(filters).toPredicate();
    }
}

