/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.discovery;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class JqwikKotlinSupport {
    public static boolean isInternalKotlinMethod(Method method) {
        Class<?> aClass = method.getDeclaringClass();
        return JqwikKotlinSupport.isKotlinClass(aClass) && JqwikKotlinSupport.isKotlinInternal(method);
    }

    public static boolean isSpeciallyNamedKotlinMethod(Method method) {
        Class<?> aClass = method.getDeclaringClass();
        return JqwikKotlinSupport.isKotlinClass(aClass) && JqwikKotlinSupport.isKotlinSpecial(method);
    }

    private static boolean isKotlinInternal(Method method) {
        return method.getName().lastIndexOf(36) > 0;
    }

    private static boolean isKotlinSpecial(Method method) {
        String name = method.getName();
        int lastIndexOfHyphen = name.lastIndexOf(45);
        return lastIndexOfHyphen >= 0 && lastIndexOfHyphen == name.length() - 8;
    }

    public static boolean isKotlinClass(Class<?> aClass) {
        for (Annotation annotation : aClass.getDeclaredAnnotations()) {
            if (!annotation.annotationType().getTypeName().equals("kotlin.Metadata")) continue;
            return true;
        }
        return false;
    }

    public static String nameWithoutInternalPart(Method targetMethod) {
        int lastDollarPosition = targetMethod.getName().lastIndexOf(36);
        return targetMethod.getName().substring(0, lastDollarPosition);
    }

    public static String nameWithoutSpecialPart(Method targetMethod) {
        int lastDollarPosition = targetMethod.getName().lastIndexOf(45);
        return targetMethod.getName().substring(0, lastDollarPosition);
    }

    public static boolean isOverloadedConstructor(Constructor<?> constructor) {
        for (Class<?> parameterType : constructor.getParameterTypes()) {
            if (!parameterType.getName().contains("DefaultConstructorMarker")) continue;
            return true;
        }
        return false;
    }
}

