/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.jqwik.api.ForAll;
import net.jqwik.api.JqwikException;
import net.jqwik.api.Reporter;
import net.jqwik.api.domains.Domain;
import net.jqwik.api.domains.DomainContext;
import net.jqwik.api.lifecycle.AroundPropertyHook;
import net.jqwik.api.lifecycle.AroundTryHook;
import net.jqwik.api.lifecycle.InvokePropertyMethodHook;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.api.lifecycle.PropertyLifecycleContext;
import net.jqwik.api.lifecycle.ResolveParameterHook;
import net.jqwik.engine.descriptor.PropertyMethodDescriptor;
import net.jqwik.engine.execution.CheckedProperty;
import net.jqwik.engine.execution.CheckedPropertyFactory;
import net.jqwik.engine.execution.CombinedDomainContext;
import net.jqwik.engine.execution.lifecycle.ExtendedPropertyExecutionResult;
import net.jqwik.engine.execution.lifecycle.LifecycleHooksSupplier;
import net.jqwik.engine.execution.lifecycle.PlainExecutionResult;
import net.jqwik.engine.execution.lifecycle.StoreRepository;
import net.jqwik.engine.execution.reporting.ExecutionResultReport;
import net.jqwik.engine.facades.DomainContextFacadeImpl;
import net.jqwik.engine.properties.PropertyCheckResult;
import net.jqwik.engine.support.JqwikExceptionSupport;
import net.jqwik.engine.support.JqwikReflectionSupport;
import org.junit.platform.commons.support.AnnotationSupport;
import org.opentest4j.TestAbortedException;

public class PropertyMethodExecutor {
    private static final Logger LOG = Logger.getLogger(PropertyMethodExecutor.class.getName());
    private final PropertyMethodDescriptor methodDescriptor;
    private final PropertyLifecycleContext propertyLifecycleContext;
    private final boolean reportOnlyFailures;
    private final CheckedPropertyFactory checkedPropertyFactory = new CheckedPropertyFactory();

    public PropertyMethodExecutor(PropertyMethodDescriptor methodDescriptor, PropertyLifecycleContext propertyLifecycleContext, boolean reportOnlyFailures) {
        this.methodDescriptor = methodDescriptor;
        this.propertyLifecycleContext = propertyLifecycleContext;
        this.reportOnlyFailures = reportOnlyFailures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyExecutionResult execute(LifecycleHooksSupplier lifecycleSupplier) {
        try {
            DomainContext domainContext = this.combineDomainContexts(this.methodDescriptor.getDomains());
            DomainContextFacadeImpl.setCurrentContext(domainContext);
            PropertyExecutionResult propertyExecutionResult = this.executePropertyMethod(lifecycleSupplier);
            return propertyExecutionResult;
        }
        finally {
            StoreRepository.getCurrent().finishScope(this.methodDescriptor);
            DomainContextFacadeImpl.removeCurrentContext();
        }
    }

    private DomainContext combineDomainContexts(Set<Domain> domainAnnotations) {
        if (domainAnnotations.isEmpty()) {
            return DomainContext.global();
        }
        Set<DomainContext> domainContexts = domainAnnotations.stream().map(this::createDomainContext).peek(domainContext -> domainContext.initialize(this.propertyLifecycleContext)).collect(Collectors.toSet());
        return new CombinedDomainContext(domainContexts);
    }

    private DomainContext createDomainContext(Domain domain) {
        Class domainContextClass = domain.value();
        try {
            DomainContext domainContext = (DomainContext)JqwikReflectionSupport.newInstanceInTestContext(domainContextClass, this.propertyLifecycleContext.testInstance());
            if (domain.priority() != Integer.MIN_VALUE) {
                domainContext.setDefaultPriority(domain.priority());
            }
            return domainContext;
        }
        catch (Throwable throwable) {
            String message = String.format("Cannot instantiate domain context @Domain(\"%s\") on [%s].", domainContextClass, this.methodDescriptor.getTargetMethod());
            throw new JqwikException(message);
        }
    }

    private PropertyExecutionResult executePropertyMethod(LifecycleHooksSupplier lifecycleSupplier) {
        PropertyExecutionResult propertyExecutionResult;
        AroundPropertyHook aroundProperty = lifecycleSupplier.aroundPropertyHook(this.methodDescriptor);
        AroundTryHook aroundTry = lifecycleSupplier.aroundTryHook(this.methodDescriptor);
        ResolveParameterHook resolveParameter = lifecycleSupplier.resolveParameterHook(this.methodDescriptor);
        InvokePropertyMethodHook invokeMethodHook = lifecycleSupplier.invokePropertyMethodHook(this.methodDescriptor);
        try {
            propertyExecutionResult = aroundProperty.aroundProperty(this.propertyLifecycleContext, () -> this.executeMethod(aroundTry, resolveParameter, invokeMethodHook));
        }
        catch (Throwable throwable) {
            JqwikExceptionSupport.rethrowIfBlacklisted(throwable);
            propertyExecutionResult = PlainExecutionResult.failed(throwable, this.methodDescriptor.getConfiguration().getSeed());
        }
        StoreRepository.getCurrent().finishProperty(this.methodDescriptor);
        this.reportResult(this.propertyLifecycleContext.reporter(), propertyExecutionResult);
        return propertyExecutionResult;
    }

    private ExtendedPropertyExecutionResult executeMethod(AroundTryHook aroundTry, ResolveParameterHook resolveParameter, InvokePropertyMethodHook invokeMethodHook) {
        try {
            return this.executeProperty(aroundTry, resolveParameter, invokeMethodHook);
        }
        catch (TestAbortedException e) {
            return PlainExecutionResult.aborted(e, this.methodDescriptor.getConfiguration().getSeed());
        }
        catch (Throwable t) {
            JqwikExceptionSupport.rethrowIfBlacklisted(t);
            return PlainExecutionResult.failed(t, this.methodDescriptor.getConfiguration().getSeed());
        }
    }

    private PropertyCheckResult executeProperty(AroundTryHook aroundTry, ResolveParameterHook resolveParameter, InvokePropertyMethodHook invokeMethodHook) {
        CheckedProperty property = this.checkedPropertyFactory.fromDescriptor(this.methodDescriptor, this.propertyLifecycleContext, aroundTry, resolveParameter, invokeMethodHook);
        return property.check(this.methodDescriptor.getReporting());
    }

    private void reportResult(Reporter reporter, PropertyExecutionResult executionResult) {
        if (executionResult.status() == PropertyExecutionResult.Status.SUCCESSFUL && this.reportOnlyFailures) {
            return;
        }
        if (executionResult instanceof ExtendedPropertyExecutionResult) {
            if (this.isReportWorthy((ExtendedPropertyExecutionResult)executionResult)) {
                String reportEntry = ExecutionResultReport.from(this.methodDescriptor, (ExtendedPropertyExecutionResult)executionResult);
                reporter.publishValue(this.methodDescriptor.extendedLabel(), reportEntry);
            }
        } else {
            String message = String.format("Unknown PropertyExecutionResult implementation: %s", executionResult.getClass());
            LOG.warning(message);
        }
    }

    private boolean isReportWorthy(ExtendedPropertyExecutionResult executionResult) {
        if (executionResult.status() != PropertyExecutionResult.Status.SUCCESSFUL) {
            return true;
        }
        if (this.hasAtLeastOneForAllParameter(this.methodDescriptor.getTargetMethod())) {
            return true;
        }
        return executionResult.countTries() > 1;
    }

    private boolean hasAtLeastOneForAllParameter(Method targetMethod) {
        for (Parameter parameter : targetMethod.getParameters()) {
            if (!AnnotationSupport.findAnnotation((AnnotatedElement)parameter, ForAll.class).isPresent()) continue;
            return true;
        }
        return false;
    }
}

