/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.hooks.lifecycle;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.function.Predicate;
import net.jqwik.api.ForAll;
import net.jqwik.api.JqwikException;
import net.jqwik.api.lifecycle.AddLifecycleHook;
import net.jqwik.api.lifecycle.AfterContainer;
import net.jqwik.api.lifecycle.AfterProperty;
import net.jqwik.api.lifecycle.AfterTry;
import net.jqwik.api.lifecycle.BeforeContainer;
import net.jqwik.api.lifecycle.BeforeProperty;
import net.jqwik.api.lifecycle.BeforeTry;
import net.jqwik.engine.support.JqwikReflectionSupport;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;

class LifecycleMethods {
    private LifecycleMethods() {
    }

    static List<Method> findBeforeContainerMethods(Class<?> testClass) {
        return LifecycleMethods.findMethods(testClass, true, true, BeforeContainer.class, HierarchyTraversalMode.TOP_DOWN);
    }

    static List<Method> findAfterContainerMethods(Class<?> testClass) {
        return LifecycleMethods.findMethods(testClass, true, true, AfterContainer.class, HierarchyTraversalMode.BOTTOM_UP);
    }

    static List<Method> findBeforePropertyMethods(Class<?> testClass) {
        return LifecycleMethods.findMethods(testClass, false, true, BeforeProperty.class, HierarchyTraversalMode.TOP_DOWN);
    }

    static List<Method> findAfterPropertyMethods(Class<?> testClass) {
        return LifecycleMethods.findMethods(testClass, false, true, AfterProperty.class, HierarchyTraversalMode.BOTTOM_UP);
    }

    static List<Method> findBeforeTryMethods(Class<?> testClass) {
        return LifecycleMethods.findMethods(testClass, false, true, BeforeTry.class, HierarchyTraversalMode.TOP_DOWN);
    }

    static List<Method> findAfterTryMethods(Class<?> testClass) {
        return LifecycleMethods.findMethods(testClass, false, true, AfterTry.class, HierarchyTraversalMode.BOTTOM_UP);
    }

    private static void assertStatic(Class<? extends Annotation> annotationType, Method method) {
        if (JqwikReflectionSupport.isNotStatic(method)) {
            throw new JqwikException(String.format("@%s method '%s' must be static.", annotationType.getSimpleName(), method.toGenericString()));
        }
    }

    private static void assertNonStatic(Class<? extends Annotation> annotationType, Method method) {
        if (JqwikReflectionSupport.isStatic(method)) {
            throw new JqwikException(String.format("@%s method '%s' must not be static.", annotationType.getSimpleName(), method.toGenericString()));
        }
    }

    private static void assertVoid(Class<? extends Annotation> annotationType, Method method) {
        if (!JqwikReflectionSupport.returnsVoid(method)) {
            throw new JqwikException(String.format("@%s method '%s' must not return a value.", annotationType.getSimpleName(), method.toGenericString()));
        }
    }

    private static void assertNoForAllParams(Class<? extends Annotation> annotationType, Method method) {
        for (Parameter parameter : method.getParameters()) {
            AnnotationSupport.findAnnotation((AnnotatedElement)parameter, ForAll.class).ifPresent(ignore -> {
                throw new JqwikException(String.format("@%s method '%s' must not have parameters annotated with @ForAll.", annotationType.getSimpleName(), method.toGenericString()));
            });
        }
    }

    private static void assertNoAddLifecycleHookAnnotations(Class<? extends Annotation> annotationType, Method method) {
        AnnotationSupport.findAnnotation((AnnotatedElement)method, AddLifecycleHook.class).ifPresent(annotation -> {
            throw new JqwikException(String.format("@%s method '%s' does not support lifecycle hook annotation: [%s].", annotationType.getSimpleName(), method.toGenericString(), annotation));
        });
    }

    private static void assertNoParams(Class<? extends Annotation> annotationType, Method method) {
        if (method.getParameterCount() > 0) {
            throw new JqwikException(String.format("@%s method '%s' must not have parameters.", annotationType.getSimpleName(), method.toGenericString()));
        }
    }

    private static List<Method> findMethods(Class<?> testClass, boolean mustBeStatic, boolean canHaveParameters, Class<? extends Annotation> annotationType, HierarchyTraversalMode traversalMode) {
        List<Method> methods = LifecycleMethods.findMethodsAndCheckVoidReturnType(testClass, mustBeStatic, annotationType, traversalMode);
        if (mustBeStatic) {
            methods.forEach(method -> LifecycleMethods.assertStatic(annotationType, method));
        } else {
            methods.forEach(method -> LifecycleMethods.assertNonStatic(annotationType, method));
        }
        methods.forEach(method -> LifecycleMethods.assertNoForAllParams(annotationType, method));
        methods.forEach(method -> LifecycleMethods.assertNoAddLifecycleHookAnnotations(annotationType, method));
        if (!canHaveParameters) {
            methods.forEach(method -> LifecycleMethods.assertNoParams(annotationType, method));
        }
        return methods;
    }

    private static List<Method> findMethodsAndCheckVoidReturnType(Class<?> testClass, boolean mustBeStatic, Class<? extends Annotation> annotationType, HierarchyTraversalMode traversalMode) {
        List<Method> methods = mustBeStatic ? LifecycleMethods.findStaticMethods(testClass, annotationType, traversalMode) : LifecycleMethods.findNonStaticMethods(testClass, annotationType, traversalMode);
        methods.forEach(method -> LifecycleMethods.assertVoid(annotationType, method));
        return methods;
    }

    private static List<Method> findStaticMethods(Class<?> testClass, Class<? extends Annotation> annotationType, HierarchyTraversalMode traversalMode) {
        return AnnotationSupport.findAnnotatedMethods(testClass, annotationType, (HierarchyTraversalMode)traversalMode);
    }

    private static List<Method> findNonStaticMethods(Class<?> testClass, Class<? extends Annotation> annotationType, HierarchyTraversalMode traversalMode) {
        Predicate<Method> isAnnotated = method -> AnnotationSupport.isAnnotated((AnnotatedElement)method, (Class)annotationType);
        return JqwikReflectionSupport.findMethodsPotentiallyOuter(testClass, isAnnotated, traversalMode);
    }
}

