/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.Tuple;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.properties.ForAllParametersGenerator;
import net.jqwik.engine.properties.IncompatibleDataException;
import net.jqwik.engine.support.JqwikStringSupport;
import net.jqwik.engine.support.MethodParameter;
import net.jqwik.engine.support.types.TypeUsageImpl;

public class DataBasedShrinkablesGenerator
implements ForAllParametersGenerator {
    private final List<MethodParameter> forAllParameters;
    private final Iterator<? extends Tuple> iterator;

    public DataBasedShrinkablesGenerator(List<MethodParameter> forAllParameters, Iterable<? extends Tuple> data) {
        this.forAllParameters = forAllParameters;
        this.iterator = data.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public List<Shrinkable<Object>> next() {
        Tuple tuple = this.iterator.next();
        this.checkCompatibility(tuple);
        return tuple.items().stream().map(Shrinkable::unshrinkable).collect(Collectors.toList());
    }

    private void checkCompatibility(Tuple tuple) {
        if (tuple.size() != this.forAllParameters.size()) {
            throw new IncompatibleDataException(this.createIncompatibilityMessage(tuple));
        }
        for (int i = 0; i < tuple.items().size(); ++i) {
            TypeUsage parameterType;
            TypeUsage valueType = TypeUsage.of(tuple.items().get(i).getClass(), (TypeUsage[])new TypeUsage[0]);
            if (valueType.canBeAssignedTo(parameterType = TypeUsageImpl.forParameter(this.forAllParameters.get(i)))) continue;
            throw new IncompatibleDataException(this.createIncompatibilityMessage(tuple));
        }
    }

    private String createIncompatibilityMessage(Tuple tuple) {
        List parameterTypes = this.forAllParameters.stream().map(TypeUsageImpl::forParameter).collect(Collectors.toList());
        return String.format("Data tuple %s is not compatible with parameters %s", tuple, JqwikStringSupport.displayString(parameterTypes));
    }
}

