/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.jqwik.api.Falsifier;
import net.jqwik.api.Reporter;
import net.jqwik.api.Reporting;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.lifecycle.FalsifiedSample;
import net.jqwik.api.lifecycle.ShrunkFalsifiedSample;
import net.jqwik.api.lifecycle.TryExecutionResult;
import net.jqwik.api.lifecycle.TryLifecycleContext;
import net.jqwik.engine.descriptor.PropertyConfiguration;
import net.jqwik.engine.execution.ParametersGenerator;
import net.jqwik.engine.execution.lifecycle.TryLifecycleExecutor;
import net.jqwik.engine.execution.reporting.SampleReporter;
import net.jqwik.engine.properties.FalsifiedSampleImpl;
import net.jqwik.engine.properties.PropertyCheckResult;
import net.jqwik.engine.properties.shrinking.PropertyShrinker;
import net.jqwik.engine.support.JqwikExceptionSupport;

public class GenericProperty {
    private final String name;
    private final PropertyConfiguration configuration;
    private final ParametersGenerator parametersGenerator;
    private final TryLifecycleExecutor tryLifecycleExecutor;
    private final Supplier<TryLifecycleContext> tryLifecycleContextSupplier;

    public GenericProperty(String name, PropertyConfiguration configuration, ParametersGenerator parametersGenerator, TryLifecycleExecutor tryLifecycleExecutor, Supplier<TryLifecycleContext> tryLifecycleContextSupplier) {
        this.name = name;
        this.configuration = configuration;
        this.parametersGenerator = parametersGenerator;
        this.tryLifecycleExecutor = tryLifecycleExecutor;
        this.tryLifecycleContextSupplier = tryLifecycleContextSupplier;
    }

    public PropertyCheckResult check(Reporter reporter, Reporting[] reporting) {
        int maxTries = this.configuration.getTries();
        int countChecks = 0;
        int countTries = 0;
        boolean finishEarly = false;
        block9: while (countTries < maxTries && !finishEarly && this.parametersGenerator.hasNext()) {
            List<Shrinkable<Object>> shrinkableParams;
            ++countTries;
            TryLifecycleContext tryLifecycleContext = this.tryLifecycleContextSupplier.get();
            try {
                shrinkableParams = this.parametersGenerator.next(tryLifecycleContext);
            }
            catch (Throwable throwable) {
                JqwikExceptionSupport.rethrowIfBlacklisted(throwable);
                return this.exhaustedCheckResult(maxTries, countChecks, throwable);
            }
            List<Object> sample = this.extractParams(shrinkableParams);
            try {
                ++countChecks;
                TryExecutionResult tryExecutionResult = this.testPredicate(tryLifecycleContext, sample, reporter, reporting);
                switch (tryExecutionResult.status()) {
                    case SATISFIED: {
                        finishEarly = tryExecutionResult.shouldPropertyFinishEarly();
                        continue block9;
                    }
                    case FALSIFIED: {
                        FalsifiedSampleImpl falsifiedSample = new FalsifiedSampleImpl(sample, shrinkableParams, tryExecutionResult.throwable(), tryExecutionResult.footnotes());
                        return this.shrinkAndCreateCheckResult(reporter, reporting, countChecks, countTries, falsifiedSample, tryLifecycleContext.targetMethod());
                    }
                    case INVALID: {
                        --countChecks;
                        if (maxTries != 1) continue block9;
                        return PropertyCheckResult.skipExample(this.configuration.getStereotype(), this.name, this.configuration.getSeed(), this.configuration.getGenerationMode(), this.configuration.getEdgeCasesMode(), this.parametersGenerator.edgeCasesTotal(), this.parametersGenerator.edgeCasesTried(), tryExecutionResult.throwable().orElse(null));
                    }
                    default: {
                        String message = String.format("Unknown TryExecutionResult.status [%s]", tryExecutionResult.status().name());
                        throw new RuntimeException(message);
                    }
                }
            }
            catch (Throwable throwable) {
                JqwikExceptionSupport.rethrowIfBlacklisted(throwable);
                FalsifiedSampleImpl falsifiedSample = new FalsifiedSampleImpl(sample, shrinkableParams, Optional.of(throwable), Collections.emptyList());
                return PropertyCheckResult.failed(this.configuration.getStereotype(), this.name, countTries, countChecks, this.configuration.getSeed(), this.configuration.getGenerationMode(), this.configuration.getEdgeCasesMode(), this.parametersGenerator.edgeCasesTotal(), this.parametersGenerator.edgeCasesTried(), falsifiedSample, null, throwable);
            }
        }
        if (countChecks == 0 || this.maxDiscardRatioExceeded(countChecks, countTries, this.configuration.getMaxDiscardRatio())) {
            return this.exhaustedCheckResult(maxTries, countChecks, null);
        }
        return PropertyCheckResult.successful(this.configuration.getStereotype(), this.name, countTries, countChecks, this.configuration.getSeed(), this.configuration.getGenerationMode(), this.configuration.getEdgeCasesMode(), this.parametersGenerator.edgeCasesTotal(), this.parametersGenerator.edgeCasesTried());
    }

    private PropertyCheckResult exhaustedCheckResult(int maxTries, int countChecks, Throwable throwable) {
        return PropertyCheckResult.exhausted(this.configuration.getStereotype(), this.name, maxTries, countChecks, this.configuration.getSeed(), this.configuration.getGenerationMode(), this.configuration.getEdgeCasesMode(), this.parametersGenerator.edgeCasesTotal(), this.parametersGenerator.edgeCasesTried(), throwable);
    }

    private TryExecutionResult testPredicate(TryLifecycleContext tryLifecycleContext, List<Object> sample, Reporter reporter, Reporting[] reporting) {
        if (Reporting.GENERATED.containedIn(reporting)) {
            Map<String, Object> reports = SampleReporter.createSampleReports(tryLifecycleContext.targetMethod(), sample);
            reporter.publishReports("generated", reports);
        }
        return this.tryLifecycleExecutor.execute(tryLifecycleContext, sample);
    }

    private boolean maxDiscardRatioExceeded(int countChecks, int countTries, int maxDiscardRatio) {
        int actualDiscardRatio = (countTries - countChecks) / countChecks;
        return actualDiscardRatio > maxDiscardRatio;
    }

    private List<Object> extractParams(List<Shrinkable<Object>> shrinkableParams) {
        return shrinkableParams.stream().map(Shrinkable::value).collect(Collectors.toList());
    }

    private PropertyCheckResult shrinkAndCreateCheckResult(Reporter reporter, Reporting[] reporting, int countChecks, int countTries, FalsifiedSample originalSample, Method targetMethod) {
        ShrunkFalsifiedSample shrunkSample = this.shrink(reporter, reporting, originalSample, targetMethod);
        return PropertyCheckResult.failed(this.configuration.getStereotype(), this.name, countTries, countChecks, this.configuration.getSeed(), this.configuration.getGenerationMode(), this.configuration.getEdgeCasesMode(), this.parametersGenerator.edgeCasesTotal(), this.parametersGenerator.edgeCasesTried(), originalSample, shrunkSample, shrunkSample.falsifyingError().orElse(null));
    }

    private ShrunkFalsifiedSample shrink(Reporter reporter, Reporting[] reporting, FalsifiedSample originalSample, Method targetMethod) {
        Consumer<FalsifiedSample> falsifiedSampleReporter = this.createFalsifiedSampleReporter(reporter, reporting);
        PropertyShrinker shrinker = new PropertyShrinker(originalSample, this.configuration.getShrinkingMode(), this.configuration.boundedShrinkingSeconds(), falsifiedSampleReporter, targetMethod);
        Falsifier<List<Object>> forAllFalsifier = this.createFalsifier(this.tryLifecycleContextSupplier, this.tryLifecycleExecutor);
        return shrinker.shrink(forAllFalsifier);
    }

    private Consumer<FalsifiedSample> createFalsifiedSampleReporter(Reporter reporter, Reporting[] reporting) {
        return sample -> {
            if (Reporting.FALSIFIED.containedIn(reporting)) {
                TryLifecycleContext tryLifecycleContext = this.tryLifecycleContextSupplier.get();
                Map<String, Object> reports = SampleReporter.createSampleReports(tryLifecycleContext.targetMethod(), sample.parameters());
                reporter.publishReports("falsified", reports);
            }
        };
    }

    private Falsifier<List<Object>> createFalsifier(Supplier<TryLifecycleContext> tryLifecycleContext, TryLifecycleExecutor tryExecutor) {
        return params -> tryExecutor.execute((TryLifecycleContext)tryLifecycleContext.get(), (List<Object>)params);
    }
}

