/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.configurators;

import java.math.BigDecimal;
import java.util.function.Function;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.BigDecimalArbitrary;
import net.jqwik.api.configurators.ArbitraryConfiguratorBase;
import net.jqwik.api.constraints.BigRange;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.properties.arbitraries.DefaultBigDecimalArbitrary;

public class BigDecimalRangeConfigurator
extends ArbitraryConfiguratorBase {
    protected boolean acceptTargetType(TypeUsage targetType) {
        return targetType.isAssignableFrom(BigDecimal.class);
    }

    public Arbitrary<BigDecimal> configure(Arbitrary<BigDecimal> arbitrary, BigRange range) {
        BigDecimal min = BigDecimalRangeConfigurator.evaluate(range.min(), BigDecimal::new, DefaultBigDecimalArbitrary.DEFAULT_MIN);
        BigDecimal max = BigDecimalRangeConfigurator.evaluate(range.max(), BigDecimal::new, DefaultBigDecimalArbitrary.DEFAULT_MAX);
        if (arbitrary instanceof BigDecimalArbitrary) {
            return ((BigDecimalArbitrary)arbitrary).between(min, range.minIncluded(), max, range.maxIncluded());
        }
        return arbitrary.filter(i -> {
            boolean minCondition;
            boolean bl = range.minIncluded() ? min.compareTo((BigDecimal)i) <= 0 : (minCondition = min.compareTo((BigDecimal)i) < 0);
            boolean maxCondition = range.maxIncluded() ? max.compareTo((BigDecimal)i) >= 0 : max.compareTo((BigDecimal)i) > 0;
            return minCondition && maxCondition;
        });
    }

    private static BigDecimal evaluate(String valueString, Function<String, BigDecimal> evaluator, BigDecimal defaultValue) {
        return valueString.isEmpty() ? defaultValue : evaluator.apply(valueString);
    }
}

