/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Stream;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.engine.properties.FeatureExtractor;
import net.jqwik.engine.properties.UniquenessChecker;
import net.jqwik.engine.properties.shrinking.AggressiveSizeOfListShrinker;
import net.jqwik.engine.properties.shrinking.ShrinkingCommons;
import net.jqwik.engine.properties.shrinking.SizeOfListShrinker;
import net.jqwik.engine.support.Combinatorics;
import net.jqwik.engine.support.JqwikStreamSupport;

abstract class ShrinkableContainer<C, E>
implements Shrinkable<C> {
    protected final List<Shrinkable<E>> elements;
    protected final int minSize;
    protected final int maxSize;
    protected final Collection<FeatureExtractor<E>> uniquenessExtractors;

    ShrinkableContainer(List<Shrinkable<E>> elements, int minSize, int maxSize, Collection<FeatureExtractor<E>> uniquenessExtractors) {
        this.elements = elements;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.uniquenessExtractors = uniquenessExtractors;
    }

    private C createValue(List<Shrinkable<E>> shrinkables) {
        return shrinkables.stream().map(Shrinkable::value).collect(this.containerCollector());
    }

    public C value() {
        return this.createValue(this.elements);
    }

    public Stream<Shrinkable<C>> shrink() {
        return JqwikStreamSupport.concat(this.shrinkSizeOfList(), this.shrinkElementsOneAfterTheOther(0), this.shrinkPairsOfElements());
    }

    public Optional<Shrinkable<C>> grow(Shrinkable<?> before, Shrinkable<?> after) {
        if (before instanceof ShrinkableContainer && after instanceof ShrinkableContainer) {
            ArrayList<Shrinkable<Shrinkable<E>>> removedShrinkables = new ArrayList<Shrinkable<Shrinkable<E>>>(((ShrinkableContainer)before).elements);
            removedShrinkables.removeAll(((ShrinkableContainer)after).elements);
            return this.growBy(removedShrinkables);
        }
        return Optional.empty();
    }

    public Stream<Shrinkable<C>> grow() {
        return this.growOneElementAfterTheOther();
    }

    private Stream<Shrinkable<C>> growOneElementAfterTheOther() {
        ArrayList growPerElementStreams = new ArrayList();
        for (int i = 0; i < this.elements.size(); ++i) {
            int index = i;
            Shrinkable<E> element = this.elements.get(i);
            Stream shrinkElement = element.grow().flatMap(shrunkElement -> {
                ArrayList<Shrinkable<Shrinkable>> elementsCopy = new ArrayList<Shrinkable<Shrinkable>>(this.elements);
                elementsCopy.set(index, (Shrinkable<Shrinkable>)shrunkElement);
                return Stream.of(this.createShrinkable(elementsCopy));
            });
            growPerElementStreams.add(shrinkElement);
        }
        return JqwikStreamSupport.concat(growPerElementStreams);
    }

    private Optional<Shrinkable<C>> growBy(List<Shrinkable<?>> shrinkables) {
        if (this.elements.size() + shrinkables.size() <= this.maxSize) {
            ArrayList grownElements = new ArrayList(this.elements);
            for (Shrinkable<?> shrinkable : shrinkables) {
                try {
                    Shrinkable<?> castShrinkable = shrinkable;
                    grownElements.add(0, castShrinkable);
                }
                catch (Throwable classCastException) {
                    return Optional.empty();
                }
            }
            Shrinkable<C> grownShrinkable = this.createShrinkable(grownElements);
            if (this.hasReallyGrown(grownShrinkable)) {
                return Optional.of(grownShrinkable);
            }
        }
        return Optional.empty();
    }

    protected boolean hasReallyGrown(Shrinkable<C> grownShrinkable) {
        return true;
    }

    protected Stream<Shrinkable<C>> shrinkSizeAggressively() {
        return new AggressiveSizeOfListShrinker<Shrinkable<E>>(this.minSize).shrink(this.elements).map(this::createShrinkable).sorted(Comparator.comparing(Shrinkable::distance));
    }

    protected Stream<Shrinkable<C>> shrinkSizeOfList() {
        return new SizeOfListShrinker<Shrinkable<E>>(this.minSize).shrink(this.elements).map(this::createShrinkable).sorted(Comparator.comparing(Shrinkable::distance));
    }

    protected Stream<Shrinkable<C>> shrinkElementsOneAfterTheOther(int maxToShrink) {
        ArrayList shrinkPerElementStreams = new ArrayList();
        for (int i = 0; i < this.elements.size() && (maxToShrink <= 0 || i < maxToShrink); ++i) {
            int index = i;
            Shrinkable<E> element = this.elements.get(i);
            Stream shrinkElement = element.shrink().flatMap(shrunkElement -> {
                ArrayList<Shrinkable<Shrinkable>> elementsCopy = new ArrayList<Shrinkable<Shrinkable>>(this.elements);
                elementsCopy.remove(index);
                if (!UniquenessChecker.checkShrinkableUniqueIn(this.uniquenessExtractors, shrunkElement, elementsCopy)) {
                    return Stream.empty();
                }
                elementsCopy.add(index, (Shrinkable<Shrinkable>)shrunkElement);
                return Stream.of(this.createShrinkable(elementsCopy));
            });
            shrinkPerElementStreams.add(shrinkElement);
        }
        return JqwikStreamSupport.concat(shrinkPerElementStreams);
    }

    protected Stream<Shrinkable<C>> shrinkPairsOfElements() {
        return Combinatorics.distinctPairs(this.elements.size()).flatMap(pair -> JqwikStreamSupport.zip(this.elements.get((Integer)pair.get1()).shrink(), this.elements.get((Integer)pair.get2()).shrink(), (s1, s2) -> {
            ArrayList<Shrinkable<Shrinkable>> newElements = new ArrayList<Shrinkable<Shrinkable>>(this.elements);
            newElements.set((Integer)pair.get1(), (Shrinkable<Shrinkable>)s1);
            newElements.set((Integer)pair.get2(), (Shrinkable<Shrinkable>)s2);
            if (UniquenessChecker.checkUniquenessOfShrinkables(this.uniquenessExtractors, newElements)) {
                return this.createShrinkable(newElements);
            }
            return null;
        }));
    }

    protected Stream<Shrinkable<C>> sortElements() {
        return ShrinkingCommons.sortElements(this.elements, this::createShrinkable);
    }

    public ShrinkingDistance distance() {
        return ShrinkingDistance.forCollection(this.elements);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShrinkableContainer that = (ShrinkableContainer)o;
        return this.value().equals(that.value());
    }

    public int hashCode() {
        return Objects.hash(this.elements);
    }

    public String toString() {
        return String.format("%s<%s>(%s:%s)", this.getClass().getSimpleName(), this.value().getClass().getSimpleName(), this.value(), this.distance());
    }

    abstract Shrinkable<C> createShrinkable(List<Shrinkable<E>> var1);

    abstract Collector<E, ?, C> containerCollector();
}

