/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine;

import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jqwik.api.AfterFailureMode;
import net.jqwik.api.EdgeCasesMode;
import net.jqwik.api.FixedSeedMode;
import net.jqwik.api.GenerationMode;
import net.jqwik.api.ShrinkingMode;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.support.config.PrefixedConfigurationParameters;

public class JqwikProperties {
    public static final int DEFAULT_TRIES = 1000;
    private static final String PROPERTIES_FILE_NAME = "jqwik.properties";
    private static final String CONFIGURATION_PARAMETERS_PREFIX = "jqwik.";
    private static final Logger LOG = Logger.getLogger(JqwikProperties.class.getName());
    private static final String DEFAULT_DATABASE_PATH = ".jqwik-database";
    private static final boolean DEFAULT_RERUN_FAILURES_FIRST = false;
    private static final int DEFAULT_MAX_DISCARD_RATIO = 5;
    private static final AfterFailureMode DEFAULT_AFTER_FAILURE = AfterFailureMode.PREVIOUS_SEED;
    private static final boolean DEFAULT_REPORT_ONLY_FAILURES = false;
    private static final GenerationMode DEFAULT_GENERATION = GenerationMode.AUTO;
    private static final EdgeCasesMode DEFAULT_EDGE_CASES = EdgeCasesMode.MIXIN;
    private static final ShrinkingMode DEFAULT_SHRINKING = ShrinkingMode.BOUNDED;
    private static final int DEFAULT_BOUNDED_SHRINKING_SECONDS = 10;
    private static final boolean DEFAULT_USE_JUNIT_PLATFORM_REPORTER = false;
    private final String databasePath;
    private final boolean runFailuresFirst;
    private final int defaultTries;
    private final int defaultMaxDiscardRatio;
    private final boolean useJunitPlatformReporter;
    private final AfterFailureMode defaultAfterFailure;
    private final boolean reportOnlyFailures;
    private final GenerationMode defaultGeneration;
    private final EdgeCasesMode defaultEdgeCases;
    private final ShrinkingMode defaultShrinking;
    private final int boundedShrinkingSeconds;
    private final FixedSeedMode fixedSeedMode;

    public String databasePath() {
        return this.databasePath;
    }

    public boolean runFailuresFirst() {
        return this.runFailuresFirst;
    }

    public int defaultTries() {
        return this.defaultTries;
    }

    public int defaultMaxDiscardRatio() {
        return this.defaultMaxDiscardRatio;
    }

    public boolean useJunitPlatformReporter() {
        return this.useJunitPlatformReporter;
    }

    public AfterFailureMode defaultAfterFailure() {
        return this.defaultAfterFailure;
    }

    public boolean reportOnlyFailures() {
        return this.reportOnlyFailures;
    }

    public GenerationMode defaultGeneration() {
        return this.defaultGeneration;
    }

    public EdgeCasesMode defaultEdgeCases() {
        return this.defaultEdgeCases;
    }

    public ShrinkingMode defaultShrinking() {
        return this.defaultShrinking;
    }

    public int boundedShrinkingSeconds() {
        return this.boundedShrinkingSeconds;
    }

    public FixedSeedMode fixedSeedMode() {
        return this.fixedSeedMode;
    }

    JqwikProperties(ConfigurationParameters parameters) {
        this.databasePath = parameters.get("database").orElse(DEFAULT_DATABASE_PATH);
        this.runFailuresFirst = parameters.getBoolean("failures.runfirst").orElse(false);
        this.defaultTries = parameters.get("tries.default", Integer::parseInt).orElse(1000);
        this.defaultMaxDiscardRatio = parameters.get("maxdiscardratio.default", Integer::parseInt).orElse(5);
        this.useJunitPlatformReporter = parameters.getBoolean("reporting.usejunitplatform").orElse(false);
        this.defaultAfterFailure = parameters.get("failures.after.default", AfterFailureMode::valueOf).orElse(DEFAULT_AFTER_FAILURE);
        this.reportOnlyFailures = parameters.getBoolean("reporting.onlyfailures").orElse(false);
        this.defaultGeneration = parameters.get("generation.default", GenerationMode::valueOf).orElse(DEFAULT_GENERATION);
        this.defaultEdgeCases = parameters.get("edgecases.default", EdgeCasesMode::valueOf).orElse(DEFAULT_EDGE_CASES);
        this.defaultShrinking = parameters.get("shrinking.default", ShrinkingMode::valueOf).orElse(DEFAULT_SHRINKING);
        this.boundedShrinkingSeconds = parameters.get("shrinking.bounded.seconds", Integer::parseInt).orElse(10);
        this.fixedSeedMode = parameters.get("seeds.whenfixed", FixedSeedMode::valueOf).orElse(FixedSeedMode.ALLOW);
    }

    static JqwikProperties load(ConfigurationParameters fromJunit) {
        JqwikProperties.severeWarningIfThereIsStillAJqwikPropertiesFile();
        PrefixedConfigurationParameters fromJunitPrefixed = new PrefixedConfigurationParameters(fromJunit, CONFIGURATION_PARAMETERS_PREFIX);
        return new JqwikProperties((ConfigurationParameters)fromJunitPrefixed);
    }

    private static void severeWarningIfThereIsStillAJqwikPropertiesFile() {
        InputStream legacyProperties = JqwikProperties.class.getClassLoader().getResourceAsStream(PROPERTIES_FILE_NAME);
        if (legacyProperties != null) {
            String message = "Since version 1.6 a jqwik.properties file is no longer supported. Please migrate to junit-platform.properties!";
            LOG.log(Level.SEVERE, message);
        }
    }
}

