/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.facades;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Tuple;
import net.jqwik.api.arbitraries.ArrayArbitrary;
import net.jqwik.api.arbitraries.IteratorArbitrary;
import net.jqwik.api.arbitraries.ListArbitrary;
import net.jqwik.api.arbitraries.SetArbitrary;
import net.jqwik.api.arbitraries.StreamArbitrary;
import net.jqwik.engine.ArbitraryDelegator;
import net.jqwik.engine.facades.Memoize;
import net.jqwik.engine.facades.SampleStreamFacade;
import net.jqwik.engine.properties.arbitraries.ArbitrariesSupport;
import net.jqwik.engine.properties.arbitraries.DefaultArrayArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultIteratorArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultListArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultSetArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultStreamArbitrary;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.GenericEdgeCasesConfiguration;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;

public class ArbitraryFacadeImpl
extends Arbitrary.ArbitraryFacade {
    public <T> ListArbitrary<T> list(Arbitrary<T> elementArbitrary) {
        return new DefaultListArbitrary<T>(elementArbitrary);
    }

    public <T> SetArbitrary<T> set(Arbitrary<T> elementArbitrary) {
        return new DefaultSetArbitrary<T>(elementArbitrary).ofMaxSize(ArbitrariesSupport.maxNumberOfElements(elementArbitrary, 255));
    }

    public <T> StreamArbitrary<T> stream(Arbitrary<T> elementArbitrary) {
        return new DefaultStreamArbitrary<T>(elementArbitrary);
    }

    public <T> IteratorArbitrary<T> iterator(Arbitrary<T> elementArbitrary) {
        return new DefaultIteratorArbitrary<T>(elementArbitrary);
    }

    public <T, A> ArrayArbitrary<T, A> array(Arbitrary<T> elementArbitrary, Class<A> arrayClass) {
        return new DefaultArrayArbitrary<T, A>(elementArbitrary, arrayClass);
    }

    public <T> Arbitrary<T> filter(Arbitrary<T> self, final Predicate<T> filterPredicate, final int maxMisses) {
        return new ArbitraryDelegator<T>(self){

            public RandomGenerator<T> generator(int genSize) {
                return super.generator(genSize).filter(filterPredicate, maxMisses);
            }

            public RandomGenerator<T> generatorWithEmbeddedEdgeCases(int genSize) {
                return super.generatorWithEmbeddedEdgeCases(genSize).filter(filterPredicate, maxMisses);
            }

            public Optional<ExhaustiveGenerator<T>> exhaustive(long maxNumberOfSamples) {
                return super.exhaustive(maxNumberOfSamples).map(generator -> generator.filter(filterPredicate, maxMisses));
            }

            public EdgeCases<T> edgeCases(int maxEdgeCases) {
                return EdgeCasesSupport.filter(super.edgeCases(maxEdgeCases), filterPredicate);
            }
        };
    }

    public <T, U> Arbitrary<U> map(final Arbitrary<T> self, final Function<T, U> mapper) {
        return new Arbitrary<U>(){

            public RandomGenerator<U> generator(int genSize) {
                return self.generator(genSize).map(mapper);
            }

            public RandomGenerator<U> generatorWithEmbeddedEdgeCases(int genSize) {
                return self.generatorWithEmbeddedEdgeCases(genSize).map(mapper);
            }

            public Optional<ExhaustiveGenerator<U>> exhaustive(long maxNumberOfSamples) {
                return self.exhaustive(maxNumberOfSamples).map(generator -> generator.map(mapper));
            }

            public EdgeCases<U> edgeCases(int maxEdgeCases) {
                return EdgeCasesSupport.map(self.edgeCases(maxEdgeCases), mapper);
            }
        };
    }

    public <T, U> Arbitrary<U> flatMap(final Arbitrary<T> self, final Function<T, Arbitrary<U>> mapper) {
        return new Arbitrary<U>(){

            public RandomGenerator<U> generator(int genSize) {
                return self.generator(genSize).flatMap(mapper, genSize, false);
            }

            public RandomGenerator<U> generatorWithEmbeddedEdgeCases(int genSize) {
                return self.generatorWithEmbeddedEdgeCases(genSize).flatMap(mapper, genSize, true);
            }

            public Optional<ExhaustiveGenerator<U>> exhaustive(long maxNumberOfSamples) {
                return self.exhaustive(maxNumberOfSamples).flatMap(generator -> ExhaustiveGenerators.flatMap(generator, mapper, maxNumberOfSamples));
            }

            public EdgeCases<U> edgeCases(int maxEdgeCases) {
                return EdgeCasesSupport.flatMapArbitrary(self.edgeCases(maxEdgeCases), mapper, maxEdgeCases);
            }
        };
    }

    public <T> Stream<T> sampleStream(Arbitrary<T> arbitrary) {
        return new SampleStreamFacade().sampleStream(arbitrary);
    }

    public <T> Arbitrary<T> injectNull(Arbitrary<T> self, double nullProbability) {
        int frequencyNull = (int)Math.round(nullProbability * 1000.0);
        int frequencyNotNull = 1000 - frequencyNull;
        if (frequencyNull <= 0) {
            return self;
        }
        if (frequencyNull >= 1000) {
            return Arbitraries.just(null);
        }
        return Arbitraries.frequencyOf((Tuple.Tuple2[])new Tuple.Tuple2[]{Tuple.of((Object)frequencyNull, (Object)Arbitraries.just(null)), Tuple.of((Object)frequencyNotNull, self)});
    }

    public <T> Arbitrary<T> ignoreException(final Arbitrary<T> self, final Class<? extends Throwable> exceptionType) {
        return new ArbitraryDelegator<T>(self){

            public RandomGenerator<T> generator(int genSize) {
                return super.generator(genSize).ignoreException(exceptionType);
            }

            public RandomGenerator<T> generatorWithEmbeddedEdgeCases(int genSize) {
                return super.generatorWithEmbeddedEdgeCases(genSize).ignoreException(exceptionType);
            }

            public Optional<ExhaustiveGenerator<T>> exhaustive(long maxNumberOfSamples) {
                return super.exhaustive(maxNumberOfSamples).map(generator -> generator.ignoreException(exceptionType));
            }

            public EdgeCases<T> edgeCases(int maxEdgeCases) {
                return EdgeCasesSupport.ignoreException(self.edgeCases(maxEdgeCases), exceptionType);
            }
        };
    }

    public <T> Arbitrary<T> dontShrink(Arbitrary<T> self) {
        return new ArbitraryDelegator<T>(self){

            public RandomGenerator<T> generator(int genSize) {
                return super.generator(genSize).dontShrink();
            }

            public RandomGenerator<T> generatorWithEmbeddedEdgeCases(int genSize) {
                return super.generatorWithEmbeddedEdgeCases(genSize).dontShrink();
            }

            public EdgeCases<T> edgeCases(int maxEdgeCases) {
                return EdgeCasesSupport.dontShrink(super.edgeCases(maxEdgeCases));
            }
        };
    }

    public <T> Arbitrary<T> configureEdgeCases(final Arbitrary<T> self, final Consumer<EdgeCases.Config<T>> configurator) {
        return new ArbitraryDelegator<T>(self){

            public EdgeCases<T> edgeCases(int maxEdgeCases) {
                GenericEdgeCasesConfiguration config = new GenericEdgeCasesConfiguration();
                return config.configure(configurator, arg_0 -> ((Arbitrary)self).edgeCases(arg_0), maxEdgeCases);
            }
        };
    }

    public <T> Arbitrary<T> withoutEdgeCases(final Arbitrary<T> self) {
        return new ArbitraryDelegator<T>(self){

            public RandomGenerator<T> generator(int genSize, boolean withEdgeCases) {
                return Memoize.memoizedGenerator(self, genSize, withEdgeCases, () -> self.generator(genSize));
            }

            public EdgeCases<T> edgeCases(int maxEdgeCases) {
                return EdgeCases.none();
            }

            public RandomGenerator<T> generatorWithEmbeddedEdgeCases(int genSize) {
                return self.generator(genSize, false);
            }
        };
    }

    public <T> RandomGenerator<T> memoizedGenerator(Arbitrary<T> self, int genSize, boolean withEdgeCases) {
        return Memoize.memoizedGenerator(self, genSize, withEdgeCases, () -> this.generator(self, genSize, withEdgeCases));
    }

    private <U> RandomGenerator<U> generator(Arbitrary<U> arbitrary, int genSize, boolean withEdgeCases) {
        if (withEdgeCases) {
            int maxEdgeCases = Math.max(genSize, 10);
            return arbitrary.generatorWithEmbeddedEdgeCases(genSize).withEdgeCases(genSize, arbitrary.edgeCases(maxEdgeCases));
        }
        return arbitrary.generator(genSize);
    }
}

