/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ForAll;
import net.jqwik.api.From;
import net.jqwik.api.JqwikException;
import net.jqwik.api.Provide;
import net.jqwik.api.providers.ArbitraryProvider;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.properties.ProviderMethodInvoker;
import net.jqwik.engine.support.JqwikReflectionSupport;
import net.jqwik.engine.support.OverriddenMethodAnnotationSupport;

abstract class InstanceBasedSubtypeProvider
implements ArbitraryProvider.SubtypeProvider {
    private final Object instance;

    protected InstanceBasedSubtypeProvider(Object instance) {
        this.instance = instance;
    }

    public Set<Arbitrary<?>> apply(TypeUsage targetType) {
        Optional<String> optionalForAllValue = targetType.findAnnotation(ForAll.class).map(ForAll::value).filter(name -> !name.equals(""));
        Optional<String> optionalFromValue = targetType.findAnnotation(From.class).map(From::value);
        if (optionalForAllValue.isPresent() && optionalFromValue.isPresent()) {
            String message = String.format("You cannot have both @ForAll(\"%s\") and @From(\"%s\") in parameter %s", optionalForAllValue.get(), optionalFromValue.get(), targetType);
            throw new JqwikException(message);
        }
        String generatorName = optionalForAllValue.orElseGet(() -> optionalFromValue.orElse(""));
        Set resolvedArbitraries = this.findArbitraryGeneratorByName(targetType, generatorName).map(providerMethod -> this.invokeProviderMethod((Method)providerMethod, targetType)).orElseGet(() -> generatorName.equals("") ? this.resolve(targetType) : Collections.emptySet());
        return resolvedArbitraries.stream().map(arbitrary -> this.configure((Arbitrary<?>)arbitrary, targetType)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private Set<Arbitrary<?>> invokeProviderMethod(Method providerMethod, TypeUsage targetType) {
        return new ProviderMethodInvoker(providerMethod, targetType, this.instance, this).invoke();
    }

    private Optional<Method> findArbitraryGeneratorByName(TypeUsage typeUsage, String generatorToFind) {
        if (generatorToFind.isEmpty()) {
            return Optional.empty();
        }
        Function<Method, String> generatorNameSupplier = method -> {
            Optional<Provide> provideAnnotation = OverriddenMethodAnnotationSupport.findDeclaredOrInheritedAnnotation(method, Provide.class);
            return provideAnnotation.map(Provide::value).orElse("");
        };
        TypeUsage targetArbitraryType = TypeUsage.of(Arbitrary.class, (TypeUsage[])new TypeUsage[]{typeUsage});
        return JqwikReflectionSupport.findGeneratorMethod(generatorToFind, this.instance.getClass(), Provide.class, generatorNameSupplier, targetArbitraryType);
    }

    protected abstract Set<Arbitrary<?>> resolve(TypeUsage var1);

    protected abstract Arbitrary<?> configure(Arbitrary<?> var1, TypeUsage var2);
}

