/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.CannotFindArbitraryException;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.EdgeCasesMode;
import net.jqwik.api.ForAll;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.properties.ArbitraryResolver;
import net.jqwik.engine.properties.EdgeCasesGenerator;
import net.jqwik.engine.properties.ForAllParametersGenerator;
import net.jqwik.engine.properties.PurelyRandomShrinkablesGenerator;
import net.jqwik.engine.properties.RandomizedParameterGenerator;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.support.MethodParameter;
import net.jqwik.engine.support.types.TypeUsageImpl;

public class RandomizedShrinkablesGenerator
implements ForAllParametersGenerator {
    private static final Logger LOG = Logger.getLogger(RandomizedShrinkablesGenerator.class.getName());
    private final PurelyRandomShrinkablesGenerator randomGenerator;
    private final EdgeCasesGenerator edgeCasesGenerator;
    private final EdgeCasesMode edgeCasesMode;
    private final int edgeCasesTotal;
    private final int baseToEdgeCaseRatio;
    private final Random random;
    private boolean allEdgeCasesGenerated = false;
    private int edgeCasesTried = 0;

    public static RandomizedShrinkablesGenerator forParameters(List<MethodParameter> parameters, ArbitraryResolver arbitraryResolver, Random random, int genSize, EdgeCasesMode edgeCasesMode) {
        List<EdgeCases<Object>> listOfEdgeCases = RandomizedShrinkablesGenerator.listOfEdgeCases(parameters, arbitraryResolver, edgeCasesMode, genSize);
        int edgeCasesTotal = RandomizedShrinkablesGenerator.calculateEdgeCasesTotal(listOfEdgeCases);
        RandomizedShrinkablesGenerator.logEdgecasesOutnumberTriesIfApplicable(genSize, edgeCasesTotal);
        return new RandomizedShrinkablesGenerator(RandomizedShrinkablesGenerator.randomShrinkablesGenerator(parameters, arbitraryResolver, genSize, edgeCasesMode.activated()), new EdgeCasesGenerator(listOfEdgeCases), edgeCasesMode, edgeCasesTotal, RandomizedShrinkablesGenerator.calculateBaseToEdgeCaseRatio(listOfEdgeCases, genSize), random);
    }

    private static void logEdgecasesOutnumberTriesIfApplicable(int genSize, int edgeCasesTotal) {
        int logEdgeCasesExceedTriesLimit = Math.max(genSize, 100);
        if (edgeCasesTotal >= logEdgeCasesExceedTriesLimit && genSize > 1) {
            String message = String.format("Edge case generation exceeds number of tries. Stopped after %s generated cases.", edgeCasesTotal);
            LOG.log(Level.INFO, message);
        }
    }

    private static int calculateEdgeCasesTotal(List<EdgeCases<Object>> listOfEdgeCases) {
        if (listOfEdgeCases.isEmpty()) {
            return 0;
        }
        return listOfEdgeCases.stream().mapToInt(EdgeCases::size).reduce(1, (a, b) -> a * b);
    }

    private static PurelyRandomShrinkablesGenerator randomShrinkablesGenerator(List<MethodParameter> parameters, ArbitraryResolver arbitraryResolver, int genSize, boolean withEdgeCases) {
        List<RandomizedParameterGenerator> parameterGenerators = RandomizedShrinkablesGenerator.parameterGenerators(parameters, arbitraryResolver, genSize, withEdgeCases);
        return new PurelyRandomShrinkablesGenerator(parameterGenerators);
    }

    private static List<RandomizedParameterGenerator> parameterGenerators(List<MethodParameter> parameters, ArbitraryResolver arbitraryResolver, int genSize, boolean withEdgeCases) {
        return parameters.stream().map(parameter -> RandomizedShrinkablesGenerator.resolveParameter(arbitraryResolver, parameter, genSize, withEdgeCases)).collect(Collectors.toList());
    }

    private static List<EdgeCases<Object>> listOfEdgeCases(List<MethodParameter> parameters, ArbitraryResolver arbitraryResolver, EdgeCasesMode edgeCasesMode, int genSize) {
        ArrayList<EdgeCases<Object>> listOfEdgeCases = new ArrayList<EdgeCases<Object>>();
        if (edgeCasesMode.activated() && !parameters.isEmpty()) {
            int maxEdgeCasesNextParameter = genSize;
            for (MethodParameter parameter : parameters) {
                EdgeCases<Object> edgeCases = RandomizedShrinkablesGenerator.resolveEdgeCases(arbitraryResolver, parameter, maxEdgeCasesNextParameter);
                if (edgeCases.isEmpty()) {
                    return Collections.emptyList();
                }
                listOfEdgeCases.add(edgeCases);
                maxEdgeCasesNextParameter = RandomizedShrinkablesGenerator.calculateNextParamMaxEdgeCases(maxEdgeCasesNextParameter, edgeCases.size());
            }
        }
        return listOfEdgeCases;
    }

    private static <T> int calculateNextParamMaxEdgeCases(int maxEdgeCases, int baseCasesSize) {
        int maxDerivedEdgeCases = Math.max(1, maxEdgeCases / baseCasesSize);
        if (maxEdgeCases % baseCasesSize > 0) {
            ++maxDerivedEdgeCases;
        }
        return maxDerivedEdgeCases;
    }

    private static int calculateBaseToEdgeCaseRatio(List<EdgeCases<Object>> edgeCases, int genSize) {
        int countEdgeCases = edgeCases.stream().mapToInt(EdgeCases::size).reduce(1, (a, b) -> Math.max(a * b, 1));
        return EdgeCasesGenerator.calculateBaseToEdgeCaseRatio(genSize, countEdgeCases);
    }

    private static EdgeCases<Object> resolveEdgeCases(ArbitraryResolver arbitraryResolver, MethodParameter parameter, int maxEdgeCases) {
        List edgeCases = RandomizedShrinkablesGenerator.resolveArbitraries(arbitraryResolver, parameter).stream().map(objectArbitrary -> objectArbitrary.edgeCases(maxEdgeCases)).collect(Collectors.toList());
        return EdgeCasesSupport.concat(edgeCases, maxEdgeCases);
    }

    private static RandomizedParameterGenerator resolveParameter(ArbitraryResolver arbitraryResolver, MethodParameter parameter, int genSize, boolean withEdgeCases) {
        Set<Arbitrary<Object>> arbitraries = RandomizedShrinkablesGenerator.resolveArbitraries(arbitraryResolver, parameter);
        return new RandomizedParameterGenerator(parameter, arbitraries, genSize, withEdgeCases);
    }

    private static Set<Arbitrary<Object>> resolveArbitraries(ArbitraryResolver arbitraryResolver, MethodParameter parameter) {
        Set<Arbitrary<Object>> arbitraries = arbitraryResolver.forParameter(parameter).stream().map(Arbitrary::asGeneric).collect(Collectors.toSet());
        if (arbitraries.isEmpty()) {
            throw new CannotFindArbitraryException(TypeUsageImpl.forParameter(parameter), parameter.getAnnotation(ForAll.class));
        }
        return arbitraries;
    }

    private RandomizedShrinkablesGenerator(PurelyRandomShrinkablesGenerator randomGenerator, EdgeCasesGenerator edgeCasesGenerator, EdgeCasesMode edgeCasesMode, int edgeCasesTotal, int baseToEdgeCaseRatio, Random random) {
        this.randomGenerator = randomGenerator;
        this.edgeCasesGenerator = edgeCasesGenerator;
        this.edgeCasesMode = edgeCasesMode;
        this.edgeCasesTotal = edgeCasesTotal;
        this.baseToEdgeCaseRatio = baseToEdgeCaseRatio;
        this.random = random;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public List<Shrinkable<Object>> next() {
        if (!this.allEdgeCasesGenerated) {
            if (this.edgeCasesMode.generateFirst()) {
                if (this.edgeCasesGenerator.hasNext()) {
                    ++this.edgeCasesTried;
                    return this.edgeCasesGenerator.next();
                }
                this.allEdgeCasesGenerated = true;
            }
            if (this.edgeCasesMode.mixIn() && this.shouldGenerateEdgeCase(this.random)) {
                if (this.edgeCasesGenerator.hasNext()) {
                    ++this.edgeCasesTried;
                    return this.edgeCasesGenerator.next();
                }
                this.allEdgeCasesGenerated = true;
            }
        }
        return this.randomGenerator.generateNext(this.random);
    }

    @Override
    public int edgeCasesTotal() {
        return this.edgeCasesTotal;
    }

    @Override
    public int edgeCasesTried() {
        return this.edgeCasesTried;
    }

    private boolean shouldGenerateEdgeCase(Random localRandom) {
        return localRandom.nextInt(this.baseToEdgeCaseRatio + 1) == 0;
    }
}

