/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.Tuple;
import net.jqwik.api.arbitraries.FunctionArbitrary;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.TypedCloneable;
import net.jqwik.engine.properties.arbitraries.randomized.ConstantFunctionGenerator;
import net.jqwik.engine.properties.arbitraries.randomized.FunctionGenerator;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;

public class DefaultFunctionArbitrary<F, R>
extends TypedCloneable
implements FunctionArbitrary<F, R> {
    private final Class<F> functionalType;
    private final Arbitrary<R> resultArbitrary;
    private final List<Tuple.Tuple2<Predicate<List<Object>>, Function<List<Object>, R>>> conditions = new ArrayList<Tuple.Tuple2<Predicate<List<Object>>, Function<List<Object>, R>>>();

    public DefaultFunctionArbitrary(Class<F> functionalType, Arbitrary<R> resultArbitrary) {
        this.functionalType = functionalType;
        this.resultArbitrary = resultArbitrary;
    }

    public RandomGenerator<F> generator(int genSize) {
        return RandomGenerators.oneOf(this.createGenerators(genSize, false));
    }

    public RandomGenerator<F> generatorWithEmbeddedEdgeCases(int genSize) {
        return RandomGenerators.oneOf(this.createGenerators(genSize, true));
    }

    public EdgeCases<F> edgeCases(int maxEdgeCases) {
        ConstantFunctionGenerator constantFunctionGenerator = this.createConstantFunctionGenerator(1000, true);
        return EdgeCasesSupport.mapShrinkable(this.resultArbitrary.edgeCases(maxEdgeCases), x$0 -> constantFunctionGenerator.createConstantFunction((Shrinkable)x$0));
    }

    private List<RandomGenerator<F>> createGenerators(int genSize, boolean withEmbeddedEdgeCases) {
        ConstantFunctionGenerator<F, R> constantFunctionGenerator = this.createConstantFunctionGenerator(genSize, withEmbeddedEdgeCases);
        FunctionGenerator<F, R> functionGenerator = new FunctionGenerator<F, R>(this.functionalType, this.resultArbitrary.generator(genSize, withEmbeddedEdgeCases), this.conditions);
        return Arrays.asList(constantFunctionGenerator, functionGenerator, functionGenerator, functionGenerator, functionGenerator);
    }

    private ConstantFunctionGenerator<F, R> createConstantFunctionGenerator(int genSize, boolean withEmbeddedEdgeCases) {
        return new ConstantFunctionGenerator<F, R>(this.functionalType, this.resultArbitrary.generator(genSize, withEmbeddedEdgeCases), this.conditions);
    }

    public <F_ extends F> FunctionArbitrary<F_, R> when(Predicate<List<Object>> parameterCondition, Function<List<Object>, R> answer) {
        DefaultFunctionArbitrary clone = (DefaultFunctionArbitrary)this.typedClone();
        clone.conditions.addAll(this.conditions);
        clone.addCondition(Tuple.of(parameterCondition, answer));
        return clone;
    }

    private void addCondition(Tuple.Tuple2<Predicate<List<Object>>, Function<List<Object>, R>> condition) {
        this.conditions.add(condition);
    }
}

