/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.JqwikException;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.Tuple;
import net.jqwik.engine.properties.FeatureExtractor;
import net.jqwik.engine.properties.Range;
import net.jqwik.engine.properties.arbitraries.randomized.ContainerGenerator;
import net.jqwik.engine.properties.arbitraries.randomized.FrequencyGenerator;
import net.jqwik.engine.properties.arbitraries.randomized.RandomDecimalGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomIntegralGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.WithEdgeCasesGenerator;
import net.jqwik.engine.properties.shrinking.ChooseValueShrinkable;
import net.jqwik.engine.properties.shrinking.SampleShrinkable;
import net.jqwik.engine.properties.shrinking.ShrinkableList;
import net.jqwik.engine.properties.shrinking.ShrinkableSet;
import net.jqwik.engine.properties.shrinking.ShrinkableString;

public class RandomGenerators {
    public static final int DEFAULT_COLLECTION_SIZE = 255;

    public static <U> RandomGenerator<U> choose(List<U> values) {
        if (values.size() == 0) {
            return RandomGenerators.fail("empty set of values");
        }
        return random -> {
            Object value = RandomGenerators.chooseValue(values, random);
            return new ChooseValueShrinkable(value, values);
        };
    }

    public static <U> U chooseValue(List<U> values, Random random) {
        int index = random.nextInt(values.size());
        return values.get(index);
    }

    public static <U> RandomGenerator<U> choose(U[] values) {
        return RandomGenerators.choose(Arrays.asList(values));
    }

    public static RandomGenerator<Character> choose(char[] characters) {
        ArrayList<Character> validCharacters = new ArrayList<Character>(characters.length);
        for (char character : characters) {
            validCharacters.add(Character.valueOf(character));
        }
        return RandomGenerators.choose(validCharacters);
    }

    public static RandomGenerator<Character> chars(char min, char max) {
        return RandomGenerators.integers(min, max).map(anInt -> Character.valueOf((char)anInt.intValue()));
    }

    public static RandomGenerator<Integer> integers(int min, int max) {
        BigInteger minBig = BigInteger.valueOf(min);
        BigInteger maxBig = BigInteger.valueOf(max);
        return RandomGenerators.bigIntegers(minBig, maxBig, RandomIntegralGenerators.defaultShrinkingTarget(Range.of(minBig, maxBig)), RandomDistribution.uniform()).map(BigInteger::intValueExact);
    }

    public static RandomGenerator<BigInteger> bigIntegers(BigInteger min, BigInteger max, BigInteger shrinkingTarget, RandomDistribution distribution) {
        return RandomIntegralGenerators.bigIntegers(1000, min, max, shrinkingTarget, distribution);
    }

    public static RandomGenerator<BigDecimal> bigDecimals(Range<BigDecimal> range, int scale, BigDecimal shrinkingTarget, RandomDistribution distribution) {
        return RandomDecimalGenerators.bigDecimals(1000, range, scale, distribution, shrinkingTarget);
    }

    public static <T> RandomGenerator<T> oneOf(List<RandomGenerator<T>> all) {
        return RandomGenerators.choose(all).flatMap(Function.identity());
    }

    public static <T> RandomGenerator<List<T>> shuffle(List<T> values) {
        return random -> {
            ArrayList clone = new ArrayList(values);
            Collections.shuffle(clone, random);
            return Shrinkable.unshrinkable(clone);
        };
    }

    public static RandomGenerator<String> strings(RandomGenerator<Character> elementGenerator, int minLength, int maxLength, int genSize, RandomDistribution lengthDistribution) {
        Function createShrinkable = elements -> new ShrinkableString((List<Shrinkable<Character>>)elements, minLength, maxLength);
        return RandomGenerators.container(elementGenerator, createShrinkable, minLength, maxLength, genSize, lengthDistribution, Collections.emptySet());
    }

    private static <T, C> RandomGenerator<C> container(RandomGenerator<T> elementGenerator, Function<List<Shrinkable<T>>, Shrinkable<C>> createShrinkable, int minSize, int maxSize, int genSize, RandomDistribution sizeDistribution, Set<FeatureExtractor<T>> uniquenessExtractors) {
        return new ContainerGenerator<T, C>(elementGenerator, createShrinkable, minSize, maxSize, genSize, sizeDistribution, uniquenessExtractors);
    }

    public static <T> RandomGenerator<List<T>> list(RandomGenerator<T> elementGenerator, int minSize, int maxSize, int genSize, RandomDistribution sizeDistribution, Set<FeatureExtractor<T>> uniquenessExtractors) {
        Function createShrinkable = elements -> new ShrinkableList(elements, minSize, maxSize, uniquenessExtractors);
        return RandomGenerators.container(elementGenerator, createShrinkable, minSize, maxSize, genSize, sizeDistribution, uniquenessExtractors);
    }

    public static <T> RandomGenerator<Set<T>> set(RandomGenerator<T> elementGenerator, int minSize, int maxSize, int genSize) {
        return RandomGenerators.set(elementGenerator, minSize, maxSize, genSize, null, Collections.emptySet());
    }

    public static <T> RandomGenerator<Set<T>> set(RandomGenerator<T> elementGenerator, int minSize, int maxSize, int genSize, RandomDistribution sizeDistribution, Set<FeatureExtractor<T>> uniquenessExtractors) {
        HashSet<FeatureExtractor<T>> extractors = new HashSet<FeatureExtractor<T>>(uniquenessExtractors);
        extractors.add(FeatureExtractor.identity());
        Function createShrinkable = elements -> new ShrinkableSet(elements, minSize, maxSize, uniquenessExtractors);
        return RandomGenerators.container(elementGenerator, createShrinkable, minSize, maxSize, genSize, sizeDistribution, extractors);
    }

    public static <T> RandomGenerator<T> samplesFromShrinkables(List<Shrinkable<T>> samples) {
        AtomicInteger tryCount = new AtomicInteger(0);
        return ignored -> {
            if (tryCount.get() >= samples.size()) {
                tryCount.set(0);
            }
            return (Shrinkable)samples.get(tryCount.getAndIncrement());
        };
    }

    public static <T> RandomGenerator<T> samples(T[] samples) {
        List<Shrinkable<T>> shrinkables = SampleShrinkable.listOf(samples);
        return RandomGenerators.samplesFromShrinkables(shrinkables);
    }

    public static <T> RandomGenerator<T> frequency(List<Tuple.Tuple2<Integer, T>> frequencies) {
        return new FrequencyGenerator<T>(frequencies);
    }

    public static <T> RandomGenerator<T> frequencyOf(List<Tuple.Tuple2<Integer, Arbitrary<T>>> frequencies, int genSize, boolean withEmbeddedEdgeCases) {
        return RandomGenerators.frequency(frequencies).flatMap(Function.identity(), genSize, withEmbeddedEdgeCases);
    }

    public static <T> RandomGenerator<T> withEdgeCases(RandomGenerator<T> self, int genSize, EdgeCases<T> edgeCases) {
        if (edgeCases.isEmpty()) {
            return self;
        }
        return new WithEdgeCasesGenerator<T>(self, edgeCases, genSize);
    }

    public static <T> RandomGenerator<T> fail(String message) {
        return ignored -> {
            throw new JqwikException(message);
        };
    }
}

