/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;

class ErrorEquivalenceChecker {
    private final Method targetMethod;

    ErrorEquivalenceChecker(Method targetMethod) {
        this.targetMethod = targetMethod;
    }

    boolean areEquivalent(Optional<Throwable> optionalOriginal, Optional<Throwable> optionalCurrent) {
        if (!optionalOriginal.isPresent()) {
            return !optionalCurrent.isPresent();
        }
        if (!optionalCurrent.isPresent()) {
            return false;
        }
        Throwable originalError = optionalOriginal.get();
        Throwable currentError = optionalCurrent.get();
        if (!originalError.getClass().equals(currentError.getClass())) {
            return false;
        }
        Optional<StackTraceElement> firstOriginal = this.firstRelevantStackTraceElement(originalError);
        Optional<StackTraceElement> firstCurrent = this.firstRelevantStackTraceElement(currentError);
        return firstOriginal.equals(firstCurrent);
    }

    private Optional<StackTraceElement> firstRelevantStackTraceElement(Throwable error) {
        StackTraceElement[] stackTrace = error.getStackTrace();
        return Arrays.stream(stackTrace).filter(this::belongsToTargetPropertyMethod).findFirst();
    }

    private boolean belongsToTargetPropertyMethod(StackTraceElement stackTraceElement) {
        if (this.targetMethod == null) {
            return true;
        }
        return stackTraceElement.getClassName().equals(this.targetMethod.getDeclaringClass().getName()) && stackTraceElement.getMethodName().equals(this.targetMethod.getName());
    }
}

