/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.support;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.jqwik.engine.support.JqwikAnnotationSupport;

public class ParametersHash
implements Serializable {
    private final int hash;

    public ParametersHash(Method method) {
        this(ParametersHash.calculateHash(method));
    }

    public ParametersHash(int hash) {
        this.hash = hash;
    }

    public static int calculateHash(Method method) {
        Object[] values = Arrays.stream(method.getParameters()).map(ParametersHash::hashParameter).toArray();
        return Objects.hash(values);
    }

    private static int hashParameter(Parameter parameter) {
        int annotationHash = ParametersHash.hashAnnotations(JqwikAnnotationSupport.findAllAnnotations(parameter));
        return Objects.hash(parameter.getType(), annotationHash);
    }

    private static int hashAnnotations(List<Annotation> annotations) {
        Object[] values = annotations.stream().map(annotation -> annotation.hashCode()).toArray();
        return Objects.hash(values);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParametersHash that = (ParametersHash)o;
        return this.hash == that.hash;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return String.format("ParametersHash(%s)", this.hash);
    }

    public boolean matchesMethod(Method method) {
        return this.hash == ParametersHash.calculateHash(method);
    }
}

