/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.support.combinatorics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CombinedIterator<T>
implements Iterator<List<T>> {
    private final Iterator<T> first;
    private final ArrayList<Iterable<T>> rest;
    private Iterator<List<T>> next;
    private T current = null;
    private boolean currentIsSet = false;

    public CombinedIterator(List<Iterable<T>> iterables) {
        this.rest = new ArrayList<Iterable<T>>(iterables);
        this.first = this.rest.remove(0).iterator();
        this.next = this.restIterator();
    }

    private Iterator<List<T>> restIterator() {
        return this.rest.isEmpty() ? this.emptyListIterator() : new CombinedIterator<T>(this.rest);
    }

    private Iterator<List<T>> emptyListIterator() {
        return Arrays.asList(Collections.emptyList()).iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.currentIsSet) {
            return this.next.hasNext() || this.first.hasNext();
        }
        return this.next.hasNext() && this.first.hasNext();
    }

    @Override
    public List<T> next() {
        if (this.next.hasNext()) {
            if (!this.currentIsSet) {
                this.current = this.first.next();
                this.currentIsSet = true;
            }
        } else {
            this.current = this.first.next();
            this.next = this.restIterator();
        }
        return this.prepend(this.current, this.next.next());
    }

    private List<T> prepend(T head, List<T> tail) {
        ArrayList<T> rest = new ArrayList<T>(tail);
        rest.add(0, head);
        return rest;
    }
}

