/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Provide;
import net.jqwik.api.Tuple;
import net.jqwik.api.domains.DomainContextBase;
import net.jqwik.api.providers.ArbitraryProvider;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.properties.InstanceBasedSubtypeProvider;
import net.jqwik.engine.properties.ProviderMethodInvoker;
import net.jqwik.engine.support.JqwikReflectionSupport;
import net.jqwik.engine.support.JqwikStreamSupport;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;

public class DomainContextBaseProviders {
    private static final Logger LOG = Logger.getLogger(DomainContextBaseProviders.class.getName());

    public static List<ArbitraryProvider> forContextBase(DomainContextBase base, int priority) {
        return JqwikStreamSupport.concat(DomainContextBaseProviders.providersFromProviderMethods(base, priority), DomainContextBaseProviders.providersFromInnerClasses(base, priority), DomainContextBaseProviders.providersFromBaseItself(base, priority)).collect(Collectors.toList());
    }

    private static Stream<ArbitraryProvider> providersFromProviderMethods(DomainContextBase base, int priority) {
        List methods = AnnotationSupport.findAnnotatedMethods(base.getClass(), Provide.class, (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
        DomainContextBaseProviders.warnIfMethodsHaveWrongReturnType(methods);
        DomainContextBaseProviders.warnIfProvideAnnotationHasValue(methods);
        return methods.stream().filter(method -> DomainContextBaseProviders.isArbitrary(method.getReturnType())).map(method -> new MethodBaseArbitraryProvider((Method)method, base, priority));
    }

    private static void warnIfProvideAnnotationHasValue(List<Method> methods) {
        methods.stream().filter(method -> DomainContextBaseProviders.isArbitrary(method.getReturnType())).map(method -> Tuple.of((Object)method, (Object)AnnotationSupport.findAnnotation((AnnotatedElement)method, Provide.class))).filter(methodAndProvide -> ((Optional)methodAndProvide.get2()).map(a -> !a.value().isEmpty()).orElse(false)).forEach(methodAndProvide -> {
            String message = String.format("Method %s is annotated with %s but having a value does not make sense in a domain context.", methodAndProvide.get1(), ((Optional)methodAndProvide.get2()).get());
            LOG.warning(message);
        });
    }

    private static void warnIfMethodsHaveWrongReturnType(List<Method> methods) {
        methods.stream().filter(method -> !DomainContextBaseProviders.isArbitrary(method.getReturnType())).forEach(method -> {
            String message = String.format("Method %s is annotated with @Provide but does not return an Arbitrary subtype.", method);
            LOG.warning(message);
        });
    }

    private static Stream<ArbitraryProvider> providersFromInnerClasses(DomainContextBase base, int priority) {
        Predicate<Class> implementsArbitraryProvider = clazz -> ArbitraryProvider.class.isAssignableFrom((Class<?>)clazz) && !JqwikReflectionSupport.isPrivate(clazz);
        List arbitraryProviderClasses = ReflectionSupport.findNestedClasses(base.getClass(), implementsArbitraryProvider);
        DomainContextBaseProviders.warnIfClassesHaveNoFittingConstructor(arbitraryProviderClasses);
        return arbitraryProviderClasses.stream().filter(DomainContextBaseProviders::hasFittingConstructor).map(clazz -> DomainContextBaseProviders.createArbitraryProvider(clazz, base, priority));
    }

    private static Stream<ArbitraryProvider> providersFromBaseItself(DomainContextBase base, int priority) {
        if (base instanceof ArbitraryProvider) {
            return Stream.of(new ArbitraryProviderWithPriority((ArbitraryProvider)base, priority));
        }
        return Stream.empty();
    }

    private static void warnIfClassesHaveNoFittingConstructor(List<Class<?>> classes) {
        classes.stream().filter(aClass -> !DomainContextBaseProviders.hasFittingConstructor(aClass)).forEach(DomainContextBaseProviders::warnThatNoDefaultConstructorPresent);
    }

    private static void warnThatNoDefaultConstructorPresent(Class<?> aClass) {
        String message = String.format("Class <%s> does not have a default constructor and cannot be instantiated as arbitrary provider.", aClass.getName());
        LOG.warning(message);
    }

    private static boolean hasFittingConstructor(Class<?> clazz) {
        if (JqwikReflectionSupport.isStatic(clazz)) {
            return JqwikReflectionSupport.hasDefaultConstructor(clazz);
        }
        return JqwikReflectionSupport.hasConstructor(clazz, clazz.getDeclaringClass());
    }

    private static ArbitraryProvider createArbitraryProvider(Class<?> clazz, DomainContextBase base, int priority) {
        ArbitraryProvider arbitraryProviderInstance = (ArbitraryProvider)JqwikReflectionSupport.newInstanceInTestContext(clazz, base);
        if (JqwikReflectionSupport.implementsMethod(clazz, "priority", new Class[0], ArbitraryProvider.class)) {
            return arbitraryProviderInstance;
        }
        return new ArbitraryProviderWithPriority(arbitraryProviderInstance, priority);
    }

    private static boolean isArbitrary(Class<?> type) {
        return Arbitrary.class.isAssignableFrom(type);
    }

    private static class ArbitraryProviderWithPriority
    implements ArbitraryProvider {
        private final ArbitraryProvider instance;
        private final int priority;

        private ArbitraryProviderWithPriority(ArbitraryProvider instance, int priority) {
            this.instance = instance;
            this.priority = priority;
        }

        public boolean canProvideFor(TypeUsage targetType) {
            return this.instance.canProvideFor(targetType);
        }

        public Set<Arbitrary<?>> provideFor(TypeUsage targetType, ArbitraryProvider.SubtypeProvider subtypeProvider) {
            return this.instance.provideFor(targetType, subtypeProvider);
        }

        public int priority() {
            return this.priority;
        }
    }

    private static class MethodBaseArbitraryProvider
    implements ArbitraryProvider {
        private final Method method;
        private final Object base;
        private final int priority;

        private MethodBaseArbitraryProvider(Method method, Object base, int priority) {
            this.method = method;
            this.base = base;
            this.priority = priority;
        }

        public boolean canProvideFor(TypeUsage targetType) {
            return this.targetTypeFits(targetType);
        }

        public Set<Arbitrary<?>> provideFor(TypeUsage targetType, ArbitraryProvider.SubtypeProvider subtypeProvider) {
            DomainContextBaseSubtypeProvider domainSubtypeProvider = new DomainContextBaseSubtypeProvider(this.base, subtypeProvider);
            return new ProviderMethodInvoker(this.method, targetType, this.base, domainSubtypeProvider).invoke();
        }

        public int priority() {
            return this.priority;
        }

        private boolean targetTypeFits(TypeUsage targetType) {
            TypeUsage arbitraryReturnType = this.arbitraryReturnType();
            return arbitraryReturnType.canBeAssignedTo(targetType) || targetType.canBeAssignedTo(arbitraryReturnType);
        }

        private TypeUsage arbitraryReturnType() {
            TypeUsage arbitraryType = this.arbitraryType(TypeUsage.forType((Type)this.method.getGenericReturnType()));
            return arbitraryType.getTypeArgument(0);
        }

        private TypeUsage arbitraryType(TypeUsage baseType) {
            if (!baseType.isOfType(Arbitrary.class)) {
                for (TypeUsage anInterface : baseType.getInterfaces()) {
                    if (!DomainContextBaseProviders.isArbitrary(anInterface.getRawType())) continue;
                    return this.arbitraryType(anInterface);
                }
            }
            return baseType;
        }
    }

    private static class DomainContextBaseSubtypeProvider
    extends InstanceBasedSubtypeProvider {
        private final ArbitraryProvider.SubtypeProvider baseProvider;

        protected DomainContextBaseSubtypeProvider(Object base, ArbitraryProvider.SubtypeProvider baseProvider) {
            super(base);
            this.baseProvider = baseProvider;
        }

        @Override
        protected Set<Arbitrary<?>> resolve(TypeUsage parameterType) {
            return (Set)this.baseProvider.apply((Object)parameterType);
        }

        @Override
        protected Arbitrary<?> configure(Arbitrary<?> arbitrary, TypeUsage targetType) {
            return arbitrary;
        }
    }
}

