/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.properties.FeatureExtractor;

public class UniquenessChecker {
    public static <T> boolean checkShrinkableUniqueIn(Collection<FeatureExtractor<T>> extractors, Shrinkable<T> shrinkable, List<Shrinkable<T>> shrinkables) {
        if (extractors.isEmpty()) {
            return true;
        }
        Object value = shrinkable.value();
        List elements = shrinkables.stream().map(Shrinkable::value).collect(Collectors.toList());
        return UniquenessChecker.checkValueUniqueIn(extractors, value, elements);
    }

    public static <T> boolean checkValueUniqueIn(Collection<FeatureExtractor<T>> extractors, T value, Collection<T> elements) {
        for (FeatureExtractor<T> extractor : extractors) {
            if (extractor.isUniqueIn(value, elements)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean checkUniquenessOfShrinkables(Collection<FeatureExtractor<T>> extractors, List<Shrinkable<T>> shrinkables) {
        if (extractors.isEmpty()) {
            return true;
        }
        List elements = shrinkables.stream().map(Shrinkable::value).collect(Collectors.toList());
        return UniquenessChecker.checkUniquenessOfValues(extractors, elements);
    }

    public static <T> boolean checkUniquenessOfValues(Collection<FeatureExtractor<T>> extractors, Collection<T> elements) {
        for (FeatureExtractor<T> extractor : extractors) {
            if (extractor.areUnique(elements)) continue;
            return false;
        }
        return true;
    }
}

