/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Tuple;
import net.jqwik.api.arbitraries.CharacterArbitrary;
import net.jqwik.engine.properties.arbitraries.CharacterRangeArbitrary;
import net.jqwik.engine.properties.arbitraries.TypedCloneable;

public class DefaultCharacterArbitrary
extends TypedCloneable
implements CharacterArbitrary {
    static final char[] WHITESPACE_CHARS;
    static final int MAX_ASCII_CODEPOINT = 127;
    private List<Tuple.Tuple2<Integer, Arbitrary<Character>>> partsWithSize = new ArrayList<Tuple.Tuple2<Integer, Arbitrary<Character>>>();

    static boolean isNoncharacter(int codepoint) {
        if (codepoint >= 64976 && codepoint <= 65007) {
            return true;
        }
        if (codepoint >= 55296 && codepoint <= 57343) {
            return true;
        }
        return codepoint == 65534 || codepoint == 65535;
    }

    static boolean isPrivateUseCharacter(int codepoint) {
        return codepoint >= 57344 && codepoint <= 63743;
    }

    public RandomGenerator<Character> generator(int genSize) {
        return this.arbitrary().generator(genSize);
    }

    private Arbitrary<Character> arbitrary() {
        if (this.partsWithSize.isEmpty()) {
            return this.defaultArbitrary();
        }
        if (this.partsWithSize.size() == 1) {
            return (Arbitrary)this.partsWithSize.get(0).get2();
        }
        return Arbitraries.frequencyOf(this.partsWithSize);
    }

    private Arbitrary<Character> defaultArbitrary() {
        return this.rangeArbitrary('\u0000', '\uffff').filter(c -> !DefaultCharacterArbitrary.isNoncharacter(c.charValue()) && !DefaultCharacterArbitrary.isPrivateUseCharacter(c.charValue()));
    }

    public Optional<ExhaustiveGenerator<Character>> exhaustive(long maxNumberOfSamples) {
        return this.arbitrary().exhaustive(maxNumberOfSamples);
    }

    public EdgeCases<Character> edgeCases(int maxEdgeCases) {
        return this.arbitrary().edgeCases(maxEdgeCases);
    }

    public CharacterArbitrary range(char min, char max) {
        return this.cloneWith(this.rangeArbitrary(min, max), max - min + 1);
    }

    public CharacterArbitrary with(char ... allowedChars) {
        return this.cloneWith(this.charsArbitrary(allowedChars), allowedChars.length);
    }

    public CharacterArbitrary with(CharSequence allowedChars) {
        char[] chars = allowedChars.toString().toCharArray();
        return this.with(chars);
    }

    private Arbitrary<Character> charsArbitrary(char[] allowedChars) {
        return Arbitraries.of((char[])allowedChars);
    }

    public CharacterArbitrary all() {
        return new DefaultCharacterArbitrary();
    }

    public CharacterArbitrary ascii() {
        return this.range('\u0000', '\u007f');
    }

    public CharacterArbitrary numeric() {
        return this.range('0', '9');
    }

    public CharacterArbitrary whitespace() {
        return this.with(WHITESPACE_CHARS);
    }

    public CharacterArbitrary alpha() {
        return this.range('A', 'Z').range('a', 'z');
    }

    private CharacterArbitrary cloneWith(Arbitrary<Character> part, int size) {
        DefaultCharacterArbitrary clone = (DefaultCharacterArbitrary)super.typedClone();
        clone.partsWithSize = new ArrayList<Tuple.Tuple2<Integer, Arbitrary<Character>>>(this.partsWithSize);
        clone.partsWithSize.add((Tuple.Tuple2<Integer, Arbitrary<Character>>)Tuple.of((Object)size, part));
        return clone;
    }

    private Arbitrary<Character> rangeArbitrary(char min, char max) {
        return new CharacterRangeArbitrary(min, max);
    }

    static {
        StringBuilder whitespace = IntStream.range(0, 65536).filter(Character::isWhitespace).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append);
        int whitespaceLength = whitespace.length();
        char[] charArray = new char[whitespaceLength];
        whitespace.getChars(0, whitespaceLength, charArray, 0);
        WHITESPACE_CHARS = charArray;
    }
}

