/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.arbitraries.StreamArbitrary;
import net.jqwik.engine.properties.FeatureExtractor;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.MultivalueArbitraryBase;
import net.jqwik.engine.properties.arbitraries.ReportableStream;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.shrinking.ShrinkableList;

public class DefaultStreamArbitrary<T>
extends MultivalueArbitraryBase<T, Stream<T>>
implements StreamArbitrary<T> {
    public DefaultStreamArbitrary(Arbitrary<T> elementArbitrary) {
        super(elementArbitrary);
    }

    @Override
    protected Iterable<T> toIterable(Stream<T> streamable) {
        return streamable::iterator;
    }

    public RandomGenerator<Stream<T>> generator(int genSize) {
        return this.createListGenerator(genSize, false).map(ReportableStream::new);
    }

    public RandomGenerator<Stream<T>> generatorWithEmbeddedEdgeCases(int genSize) {
        return this.createListGenerator(genSize, true).map(ReportableStream::new);
    }

    public Optional<ExhaustiveGenerator<Stream<T>>> exhaustive(long maxNumberOfSamples) {
        return ExhaustiveGenerators.list(this.elementArbitrary, this.minSize, this.maxSize, this.uniquenessExtractors, maxNumberOfSamples).map(generator -> generator.map(ReportableStream::new));
    }

    public EdgeCases<Stream<T>> edgeCases(int maxEdgeCases) {
        return EdgeCasesSupport.map(this.edgeCases((elements, minSize1) -> new ShrinkableList(elements, (int)minSize1, this.maxSize, this.uniquenessExtractors), maxEdgeCases), ReportableStream::new);
    }

    public StreamArbitrary<T> ofMaxSize(int maxSize) {
        return (StreamArbitrary)super.ofMaxSize(maxSize);
    }

    public StreamArbitrary<T> ofMinSize(int minSize) {
        return (StreamArbitrary)super.ofMinSize(minSize);
    }

    public StreamArbitrary<T> withSizeDistribution(RandomDistribution distribution) {
        return (StreamArbitrary)super.withSizeDistribution(distribution);
    }

    public StreamArbitrary<T> uniqueElements(Function<T, Object> by) {
        FeatureExtractor featureExtractor = by::apply;
        return (StreamArbitrary)super.uniqueElements(featureExtractor);
    }

    public StreamArbitrary<T> uniqueElements() {
        return (StreamArbitrary)this.uniqueElements(FeatureExtractor.identity());
    }
}

