/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.configurators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.ArrayArbitrary;
import net.jqwik.api.arbitraries.IteratorArbitrary;
import net.jqwik.api.arbitraries.ListArbitrary;
import net.jqwik.api.arbitraries.SetArbitrary;
import net.jqwik.api.arbitraries.StreamArbitrary;
import net.jqwik.api.configurators.ArbitraryConfigurator;
import net.jqwik.api.constraints.UniqueElements;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.support.JqwikReflectionSupport;

public class UniqueElementsConfigurator
implements ArbitraryConfigurator {
    public <T> Arbitrary<T> configure(Arbitrary<T> arbitrary, TypeUsage targetType) {
        return targetType.findAnnotation(UniqueElements.class).map(uniqueness -> {
            if (arbitrary instanceof ListArbitrary) {
                return this.configureListArbitrary((ListArbitrary)((ListArbitrary)arbitrary), (UniqueElements)uniqueness);
            }
            if (arbitrary instanceof SetArbitrary) {
                return this.configureSetArbitrary((SetArbitrary)((SetArbitrary)arbitrary), (UniqueElements)uniqueness);
            }
            if (arbitrary instanceof ArrayArbitrary) {
                return this.configureArrayArbitrary((ArrayArbitrary)((ArrayArbitrary)arbitrary), (UniqueElements)uniqueness);
            }
            if (arbitrary instanceof StreamArbitrary) {
                return this.configureStreamArbitrary((StreamArbitrary)((StreamArbitrary)arbitrary), (UniqueElements)uniqueness);
            }
            if (arbitrary instanceof IteratorArbitrary) {
                return this.configureIteratorArbitrary((IteratorArbitrary)((IteratorArbitrary)arbitrary), (UniqueElements)uniqueness);
            }
            if (targetType.isAssignableFrom(List.class)) {
                Arbitrary listArbitrary = arbitrary;
                return listArbitrary.filter(l -> this.isUnique((Collection<?>)l, this.extractor((UniqueElements)uniqueness)));
            }
            if (targetType.isAssignableFrom(Set.class)) {
                Arbitrary setArbitrary = arbitrary;
                return setArbitrary.filter(l -> this.isUnique((Collection<?>)l, this.extractor((UniqueElements)uniqueness)));
            }
            if (targetType.isArray()) {
                Arbitrary arrayArbitrary = arbitrary;
                return arrayArbitrary.filter(array -> this.isUnique(Arrays.asList(array), this.extractor((UniqueElements)uniqueness)));
            }
            if (targetType.isAssignableFrom(Stream.class)) {
                Arbitrary streamArbitrary = arbitrary;
                return streamArbitrary.map(s -> s.collect(Collectors.toList())).filter(l -> this.isUnique((Collection<?>)l, this.extractor((UniqueElements)uniqueness))).map(Collection::stream);
            }
            if (targetType.isAssignableFrom(Iterator.class)) {
                Arbitrary iteratorArbitrary = arbitrary;
                Arbitrary listArbitrary = iteratorArbitrary.map(this::toList);
                return listArbitrary.filter(l -> this.isUnique((Collection<?>)l, this.extractor((UniqueElements)uniqueness))).map(List::iterator);
            }
            return arbitrary;
        }).orElse(arbitrary);
    }

    private <T> List<T> toList(Iterator<T> i) {
        ArrayList<T> list = new ArrayList<T>();
        while (i.hasNext()) {
            list.add(i.next());
        }
        return list;
    }

    private boolean isUnique(Collection<?> list, Function<Object, Object> extractor) {
        Set set = list.stream().map(extractor).collect(Collectors.toSet());
        return set.size() == list.size();
    }

    private <T> Arbitrary<?> configureListArbitrary(ListArbitrary<T> arbitrary, UniqueElements uniqueness) {
        Function<?, Object> extractor = this.extractor(uniqueness);
        return arbitrary.uniqueElements(extractor);
    }

    private <T> Arbitrary<?> configureSetArbitrary(SetArbitrary<T> arbitrary, UniqueElements uniqueness) {
        Function<?, Object> extractor = this.extractor(uniqueness);
        return arbitrary.uniqueElements(extractor);
    }

    private <T> Arbitrary<?> configureArrayArbitrary(ArrayArbitrary<T, ?> arbitrary, UniqueElements uniqueness) {
        Function<?, Object> extractor = this.extractor(uniqueness);
        return arbitrary.uniqueElements(extractor);
    }

    private <T> Arbitrary<?> configureStreamArbitrary(StreamArbitrary<T> arbitrary, UniqueElements uniqueness) {
        Function<?, Object> extractor = this.extractor(uniqueness);
        return arbitrary.uniqueElements(extractor);
    }

    private <T> Arbitrary<?> configureIteratorArbitrary(IteratorArbitrary<T> arbitrary, UniqueElements uniqueness) {
        Function<?, Object> extractor = this.extractor(uniqueness);
        return arbitrary.uniqueElements(extractor);
    }

    private Function<?, Object> extractor(UniqueElements uniqueness) {
        Class extractorClass = uniqueness.by();
        return extractorClass.equals(UniqueElements.NOT_SET.class) ? Function.identity() : (Function)JqwikReflectionSupport.newInstanceWithDefaultConstructor(extractorClass);
    }
}

