/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class JqwikKotlinSupport {
    public static String javaOrKotlinName(Method targetMethod) {
        String name = targetMethod.getName();
        if (JqwikKotlinSupport.isKotlinClass(targetMethod.getDeclaringClass())) {
            if (JqwikKotlinSupport.isKotlinInternal(targetMethod)) {
                name = JqwikKotlinSupport.nameWithoutInternalPart(name);
            }
            if (JqwikKotlinSupport.isKotlinSpecial(targetMethod)) {
                name = JqwikKotlinSupport.nameWithoutSpecialPart(name);
            }
        }
        return name;
    }

    private static boolean isKotlinInternal(Method method) {
        if ((method.getModifiers() & 1) == 0) {
            return false;
        }
        return method.getName().endsWith("$kotlin");
    }

    private static boolean isKotlinSpecial(Method method) {
        String name = JqwikKotlinSupport.isKotlinInternal(method) ? JqwikKotlinSupport.nameWithoutInternalPart(method.getName()) : method.getName();
        int lastIndexOfHyphen = name.lastIndexOf(45);
        return lastIndexOfHyphen >= 0 && lastIndexOfHyphen == name.length() - 8;
    }

    private static boolean isKotlinClass(Class<?> aClass) {
        for (Annotation annotation : aClass.getDeclaredAnnotations()) {
            if (!annotation.annotationType().getTypeName().equals("kotlin.Metadata")) continue;
            return true;
        }
        return false;
    }

    private static String nameWithoutInternalPart(String name) {
        int lastDollarPosition = name.lastIndexOf(36);
        return name.substring(0, lastDollarPosition);
    }

    private static String nameWithoutSpecialPart(String name) {
        int lastDollarPosition = name.lastIndexOf(45);
        return name.substring(0, lastDollarPosition);
    }

    public static boolean isOverloadedConstructor(Constructor<?> constructor) {
        for (Class<?> parameterType : constructor.getParameterTypes()) {
            if (!parameterType.getName().contains("DefaultConstructorMarker")) continue;
            return true;
        }
        return false;
    }
}

