/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.facades;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.CannotFindArbitraryException;
import net.jqwik.api.Combinators;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Tuple;
import net.jqwik.api.arbitraries.BigDecimalArbitrary;
import net.jqwik.api.arbitraries.BigIntegerArbitrary;
import net.jqwik.api.arbitraries.ByteArbitrary;
import net.jqwik.api.arbitraries.CharacterArbitrary;
import net.jqwik.api.arbitraries.DoubleArbitrary;
import net.jqwik.api.arbitraries.FloatArbitrary;
import net.jqwik.api.arbitraries.IntegerArbitrary;
import net.jqwik.api.arbitraries.LongArbitrary;
import net.jqwik.api.arbitraries.MapArbitrary;
import net.jqwik.api.arbitraries.ShortArbitrary;
import net.jqwik.api.arbitraries.StringArbitrary;
import net.jqwik.api.arbitraries.TraverseArbitrary;
import net.jqwik.api.arbitraries.TypeArbitrary;
import net.jqwik.api.domains.DomainContext;
import net.jqwik.api.providers.ArbitraryProvider;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.api.stateful.Action;
import net.jqwik.api.stateful.ActionSequenceArbitrary;
import net.jqwik.engine.facades.DomainContextFacadeImpl;
import net.jqwik.engine.properties.RegisteredArbitraryConfigurer;
import net.jqwik.engine.properties.RegisteredArbitraryResolver;
import net.jqwik.engine.properties.arbitraries.ArbitrariesSupport;
import net.jqwik.engine.properties.arbitraries.DefaultBigDecimalArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultBigIntegerArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultByteArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultCharacterArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultDoubleArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultFloatArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultIntegerArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultLongArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultMapArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultShortArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultStringArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultTraverseArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultTypeArbitrary;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.FrequencyOfArbitrary;
import net.jqwik.engine.properties.arbitraries.LazyArbitrary;
import net.jqwik.engine.properties.arbitraries.LazyOfArbitrary;
import net.jqwik.engine.properties.arbitraries.OneOfArbitrary;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;
import net.jqwik.engine.properties.stateful.DefaultActionSequenceArbitrary;

public class ArbitrariesFacadeImpl
extends Arbitraries.ArbitrariesFacade {
    public <T> RandomGenerator<T> randomChoose(List<T> values) {
        return RandomGenerators.choose(values);
    }

    public <T> EdgeCases<T> edgeCasesChoose(List<T> values, int maxEdgeCases) {
        return EdgeCasesSupport.choose(values, maxEdgeCases);
    }

    public EdgeCases<Character> edgeCasesChoose(char[] characters, int maxEdgeCases) {
        ArrayList<Character> validCharacters = new ArrayList<Character>(characters.length);
        for (char character : characters) {
            validCharacters.add(Character.valueOf(character));
        }
        return this.edgeCasesChoose(validCharacters, maxEdgeCases);
    }

    public <T> Optional<ExhaustiveGenerator<T>> exhaustiveChoose(List<T> values, long maxNumberOfSamples) {
        return ExhaustiveGenerators.choose(values, maxNumberOfSamples);
    }

    public RandomGenerator<Character> randomChoose(char[] values) {
        return RandomGenerators.choose(values);
    }

    public Optional<ExhaustiveGenerator<Character>> exhaustiveChoose(char[] values, long maxNumberOfSamples) {
        return ExhaustiveGenerators.choose(values, maxNumberOfSamples);
    }

    public <T> Optional<ExhaustiveGenerator<T>> exhaustiveCreate(Supplier<T> supplier, long maxNumberOfSamples) {
        return ExhaustiveGenerators.create(supplier, maxNumberOfSamples);
    }

    public <T> Arbitrary<T> oneOf(Collection<Arbitrary<? extends T>> choices) {
        return new OneOfArbitrary<T>(choices);
    }

    public <T> RandomGenerator<T> randomFrequency(List<Tuple.Tuple2<Integer, T>> frequencies) {
        return RandomGenerators.frequency(frequencies);
    }

    public <T> RandomGenerator<List<T>> randomShuffle(List<T> values) {
        return RandomGenerators.shuffle(values);
    }

    public <T> Optional<ExhaustiveGenerator<List<T>>> exhaustiveShuffle(List<T> values, long maxNumberOfSamples) {
        return ExhaustiveGenerators.shuffle(values, maxNumberOfSamples);
    }

    public <M> ActionSequenceArbitrary<M> sequences(Arbitrary<? extends Action<M>> actionArbitrary) {
        return new DefaultActionSequenceArbitrary(actionArbitrary);
    }

    public <T> Arbitrary<T> frequencyOf(List<Tuple.Tuple2<Integer, Arbitrary<T>>> frequencies) {
        List aboveZeroFrequencies = frequencies.stream().filter(f -> (Integer)f.get1() > 0).collect(Collectors.toList());
        if (aboveZeroFrequencies.size() == 1) {
            return (Arbitrary)((Tuple.Tuple2)aboveZeroFrequencies.get(0)).get2();
        }
        return new FrequencyOfArbitrary(aboveZeroFrequencies);
    }

    public IntegerArbitrary integers() {
        return new DefaultIntegerArbitrary();
    }

    public LongArbitrary longs() {
        return new DefaultLongArbitrary();
    }

    public BigIntegerArbitrary bigIntegers() {
        return new DefaultBigIntegerArbitrary();
    }

    public FloatArbitrary floats() {
        return new DefaultFloatArbitrary();
    }

    public BigDecimalArbitrary bigDecimals() {
        return new DefaultBigDecimalArbitrary();
    }

    public DoubleArbitrary doubles() {
        return new DefaultDoubleArbitrary();
    }

    public ByteArbitrary bytes() {
        return new DefaultByteArbitrary();
    }

    public ShortArbitrary shorts() {
        return new DefaultShortArbitrary();
    }

    public StringArbitrary strings() {
        return new DefaultStringArbitrary();
    }

    public CharacterArbitrary chars() {
        return new DefaultCharacterArbitrary();
    }

    public <T> Arbitrary<T> lazy(Supplier<Arbitrary<T>> arbitrarySupplier) {
        return new LazyArbitrary<T>(arbitrarySupplier);
    }

    public <T> Arbitrary<T> lazyOf(List<Supplier<Arbitrary<T>>> suppliers) {
        int hashIdentifier = ArbitrariesFacadeImpl.calculateIdentifier(suppliers.size());
        return LazyOfArbitrary.of(hashIdentifier, suppliers);
    }

    public <T> TraverseArbitrary<T> traverse(Class<T> targetType, TraverseArbitrary.Traverser traverser) {
        return new DefaultTraverseArbitrary<T>(targetType, traverser);
    }

    private static int calculateIdentifier(int numberOfSuppliers) {
        try {
            throw new RuntimeException();
        }
        catch (RuntimeException rte) {
            Optional<Integer> optionalHash = Arrays.stream(rte.getStackTrace()).filter(stackTraceElement -> !stackTraceElement.getClassName().equals(ArbitrariesFacadeImpl.class.getName())).filter(stackTraceElement -> !stackTraceElement.getClassName().equals(Arbitraries.class.getName())).findFirst().map(stackTraceElement -> Objects.hash(stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getLineNumber(), numberOfSuppliers));
            return optionalHash.orElse(0);
        }
    }

    public <T> Arbitrary<T> defaultFor(Class<T> type, Class<?>[] typeParameters) {
        TypeUsage[] genericTypeParameters = (TypeUsage[])Arrays.stream(typeParameters).map(x$0 -> TypeUsage.of((Class)x$0, (TypeUsage[])new TypeUsage[0])).toArray(TypeUsage[]::new);
        return this.defaultFor(TypeUsage.of(type, (TypeUsage[])genericTypeParameters), typeUsage -> {
            throw new CannotFindArbitraryException(typeUsage);
        });
    }

    public <T> Arbitrary<T> defaultFor(TypeUsage typeUsage, Function<TypeUsage, Arbitrary<Object>> noDefaultResolver) {
        Set<Arbitrary<?>> arbitraries = ArbitrariesFacadeImpl.allDefaultsFor(typeUsage, noDefaultResolver);
        if (arbitraries.isEmpty()) {
            return noDefaultResolver.apply(typeUsage);
        }
        ArrayList arbitrariesList = new ArrayList();
        arbitraries.forEach(arbitrary -> arbitrariesList.add(arbitrary));
        return Arbitraries.oneOf(arbitrariesList);
    }

    public <T> TypeArbitrary<T> forType(Class<T> targetType) {
        return new DefaultTypeArbitrary<T>(targetType);
    }

    public <K, V> MapArbitrary<K, V> maps(Arbitrary<K> keysArbitrary, Arbitrary<V> valuesArbitrary) {
        return new DefaultMapArbitrary<K, V>(keysArbitrary, valuesArbitrary).ofMaxSize(ArbitrariesSupport.maxNumberOfElements(keysArbitrary, 255));
    }

    public <K, V> Arbitrary<Map.Entry<K, V>> entries(Arbitrary<K> keysArbitrary, Arbitrary<V> valuesArbitrary) {
        return Combinators.combine(keysArbitrary, valuesArbitrary).as(AbstractMap.SimpleEntry::new);
    }

    private static Set<Arbitrary<?>> allDefaultsFor(TypeUsage typeUsage, Function<TypeUsage, Arbitrary<Object>> noDefaultResolver) {
        DomainContext domainContext = DomainContextFacadeImpl.getCurrentContext();
        Set<Arbitrary<?>> unconfiguredArbitraries = ArbitrariesFacadeImpl.createDefaultArbitraries(typeUsage, noDefaultResolver, domainContext);
        return ArbitrariesFacadeImpl.configureDefaultArbitraries(typeUsage, domainContext, unconfiguredArbitraries);
    }

    private static Set<Arbitrary<?>> configureDefaultArbitraries(TypeUsage typeUsage, DomainContext domainContext, Set<Arbitrary<?>> unconfiguredArbitraries) {
        RegisteredArbitraryConfigurer defaultArbitraryConfigurer = new RegisteredArbitraryConfigurer(domainContext.getArbitraryConfigurators());
        return unconfiguredArbitraries.stream().map(arbitrary -> defaultArbitraryConfigurer.configure((Arbitrary<?>)arbitrary, typeUsage)).collect(Collectors.toSet());
    }

    private static Set<Arbitrary<?>> createDefaultArbitraries(TypeUsage typeUsage, Function<TypeUsage, Arbitrary<Object>> noDefaultResolver, DomainContext domainContext) {
        RegisteredArbitraryResolver defaultArbitraryResolver = new RegisteredArbitraryResolver(domainContext.getArbitraryProviders());
        ArbitraryProvider.SubtypeProvider subtypeProvider = subtypeUsage -> {
            Set<Arbitrary<?>> subtypeArbitraries = ArbitrariesFacadeImpl.allDefaultsFor(subtypeUsage, noDefaultResolver);
            if (subtypeArbitraries.isEmpty()) {
                return Collections.singleton((Arbitrary)noDefaultResolver.apply((TypeUsage)subtypeUsage));
            }
            return subtypeArbitraries;
        };
        return defaultArbitraryResolver.resolve(typeUsage, subtypeProvider);
    }

    public <T> Arbitrary<T> recursive(Supplier<Arbitrary<T>> base, Function<Arbitrary<T>, Arbitrary<T>> recur, int depth) {
        if (depth == 0) {
            return base.get();
        }
        return recur.apply(this.recursive(base, recur, depth - 1));
    }
}

