/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.api.arbitraries.TraverseArbitrary;
import net.jqwik.api.arbitraries.TypeArbitrary;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.properties.arbitraries.DefaultTraverseArbitrary;
import net.jqwik.engine.support.JqwikKotlinSupport;
import org.junit.platform.commons.support.ModifierSupport;

public class DefaultTypeArbitrary<T>
extends ArbitraryDecorator<T>
implements TypeArbitrary<T> {
    private final Class<T> targetType;
    private final Set<Executable> explicitCreators = new HashSet<Executable>();
    private final Set<Predicate<? super Constructor<?>>> constructorFilters = new HashSet();
    private final Set<Predicate<Method>> factoryMethodFilters = new HashSet<Predicate<Method>>();
    private boolean defaultsSet = true;
    private TraverseArbitrary<T> traverseArbitrary;

    public DefaultTypeArbitrary(Class<T> targetType) {
        this.targetType = targetType;
        this.addPublicConstructors();
        this.addPublicFactoryMethods();
        TypeTraverser traverser = new TypeTraverser();
        this.traverseArbitrary = new DefaultTraverseArbitrary<T>(targetType, traverser);
    }

    protected Arbitrary<T> arbitrary() {
        return this.traverseArbitrary;
    }

    public TypeArbitrary<T> use(Executable creator) {
        DefaultTypeArbitrary<T> clone = this.cloneWithoutDefaultsSet();
        clone.explicitCreators.add(creator);
        return clone;
    }

    private DefaultTypeArbitrary<T> cloneWithoutDefaultsSet() {
        DefaultTypeArbitrary clone = (DefaultTypeArbitrary)this.typedClone();
        if (clone.defaultsSet) {
            clone.explicitCreators.clear();
            clone.constructorFilters.clear();
            clone.factoryMethodFilters.clear();
            clone.defaultsSet = false;
        }
        return clone;
    }

    public TypeArbitrary<T> useConstructors(Predicate<? super Constructor<?>> filter) {
        DefaultTypeArbitrary<T> clone = this.cloneWithoutDefaultsSet();
        super.addConstructors(filter);
        return clone;
    }

    private void addConstructors(Predicate<? super Constructor<?>> filter) {
        this.constructorFilters.add(filter);
    }

    public TypeArbitrary<T> usePublicConstructors() {
        DefaultTypeArbitrary<T> clone = this.cloneWithoutDefaultsSet();
        super.addPublicConstructors();
        return clone;
    }

    private void addPublicConstructors() {
        this.addConstructors(ModifierSupport::isPublic);
    }

    public TypeArbitrary<T> useAllConstructors() {
        DefaultTypeArbitrary<T> clone = this.cloneWithoutDefaultsSet();
        super.addAllConstructors();
        return clone;
    }

    private void addAllConstructors() {
        this.addConstructors(ignore -> true);
    }

    public TypeArbitrary<T> useFactoryMethods(Predicate<Method> filter) {
        DefaultTypeArbitrary<T> clone = this.cloneWithoutDefaultsSet();
        super.addFactoryMethods(filter);
        return clone;
    }

    private void addFactoryMethods(Predicate<Method> filter) {
        this.factoryMethodFilters.add(filter);
    }

    public TypeArbitrary<T> usePublicFactoryMethods() {
        DefaultTypeArbitrary<T> clone = this.cloneWithoutDefaultsSet();
        super.addPublicFactoryMethods();
        return clone;
    }

    private void addPublicFactoryMethods() {
        this.addFactoryMethods(ModifierSupport::isPublic);
    }

    public TypeArbitrary<T> useAllFactoryMethods() {
        DefaultTypeArbitrary<T> clone = this.cloneWithoutDefaultsSet();
        super.addAllFactoryMethods();
        return clone;
    }

    private void addAllFactoryMethods() {
        this.addFactoryMethods(any -> true);
    }

    public TypeArbitrary<T> enableRecursion() {
        DefaultTypeArbitrary clone = (DefaultTypeArbitrary)this.typedClone();
        clone.traverseArbitrary = clone.traverseArbitrary.enableRecursion();
        return clone;
    }

    public String toString() {
        return String.format("TypeArbitrary<%s>", this.traverseArbitrary);
    }

    class TypeTraverser
    implements TraverseArbitrary.Traverser {
        TypeTraverser() {
        }

        public Set<Executable> findCreators(TypeUsage target) {
            HashSet<Executable> creators = new HashSet<Executable>();
            if (target.isOfType(DefaultTypeArbitrary.this.targetType)) {
                creators.addAll(DefaultTypeArbitrary.this.explicitCreators);
            }
            for (Predicate filter : DefaultTypeArbitrary.this.factoryMethodFilters) {
                this.appendFactoryMethods(creators, target, filter);
            }
            for (Predicate filter : DefaultTypeArbitrary.this.constructorFilters) {
                this.appendConstructors(creators, target, filter);
            }
            return creators;
        }

        private void appendConstructors(Set<Executable> creators, TypeUsage target, Predicate<? super Constructor<?>> filter) {
            if (ModifierSupport.isAbstract((Class)target.getRawType())) {
                return;
            }
            Arrays.stream(target.getRawType().getDeclaredConstructors()).filter(constructor -> !JqwikKotlinSupport.isOverloadedConstructor(constructor)).filter(filter).forEach(creators::add);
        }

        private void appendFactoryMethods(Set<Executable> creators, TypeUsage target, Predicate<Method> filter) {
            Arrays.stream(target.getRawType().getDeclaredMethods()).filter(ModifierSupport::isStatic).filter(creator -> this.hasFittingReturnType((Executable)creator, target)).filter(filter).forEach(creators::add);
        }

        private boolean hasFittingReturnType(Executable creator, TypeUsage target) {
            TypeUsage returnType = TypeUsage.forType((Type)creator.getAnnotatedReturnType().getType());
            return returnType.canBeAssignedTo(target);
        }
    }
}

