/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.Falsifier;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.Tuple;
import net.jqwik.api.lifecycle.FalsifiedSample;
import net.jqwik.api.lifecycle.TryExecutionResult;
import net.jqwik.engine.properties.shrinking.AbstractSampleShrinker;
import net.jqwik.engine.support.Combinatorics;
import net.jqwik.engine.support.JqwikStreamSupport;

class PairwiseParameterShrinker
extends AbstractSampleShrinker {
    public PairwiseParameterShrinker(Map<List<Object>, TryExecutionResult> falsificationCache) {
        super(falsificationCache);
    }

    @Override
    public FalsifiedSample shrink(Falsifier<List<Object>> falsifier, FalsifiedSample sample, Consumer<FalsifiedSample> shrinkSampleConsumer, Consumer<FalsifiedSample> shrinkAttemptConsumer) {
        FalsifiedSample current = sample;
        List allPairs = Combinatorics.distinctPairs(sample.shrinkables().size()).collect(Collectors.toList());
        for (Tuple.Tuple2 pair : allPairs) {
            current = this.shrinkPair(falsifier, current, shrinkSampleConsumer, shrinkAttemptConsumer, (Integer)pair.get1(), (Integer)pair.get2());
        }
        return current;
    }

    private FalsifiedSample shrinkPair(Falsifier<List<Object>> falsifier, FalsifiedSample sample, Consumer<FalsifiedSample> shrinkSampleConsumer, Consumer<FalsifiedSample> shrinkAttemptConsumer, int index1, int index2) {
        Function<List<Shrinkable<Object>>, Stream<List<Shrinkable<Object>>>> shrinker = shrinkables -> {
            Stream shrink1 = ((Shrinkable)shrinkables.get(index1)).shrink();
            Stream shrink2 = ((Shrinkable)shrinkables.get(index2)).shrink();
            return JqwikStreamSupport.zip(shrink1, shrink2, (shrinkable1, shrinkable2) -> {
                ArrayList<Shrinkable> newShrinkables = new ArrayList<Shrinkable>(sample.shrinkables());
                newShrinkables.set(index1, (Shrinkable)shrinkable1);
                newShrinkables.set(index2, (Shrinkable)shrinkable2);
                return newShrinkables;
            });
        };
        return this.shrink(falsifier, sample, shrinkSampleConsumer, shrinkAttemptConsumer, shrinker);
    }
}

