/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.jqwik.api.Falsifier;
import net.jqwik.api.lifecycle.FalsifiedSample;
import net.jqwik.api.lifecycle.TryExecutionResult;
import net.jqwik.engine.properties.shrinking.OneAfterTheOtherParameterShrinker;
import net.jqwik.engine.properties.shrinking.PairwiseParameterShrinker;
import net.jqwik.engine.properties.shrinking.ShrinkAndGrowShrinker;

class ShrinkingAlgorithm {
    private final Map<List<Object>, TryExecutionResult> falsificationCache = new HashMap<List<Object>, TryExecutionResult>();
    private final FalsifiedSample originalSample;
    private final Consumer<FalsifiedSample> shrinkSampleConsumer;
    private final Consumer<FalsifiedSample> shrinkAttemptConsumer;

    ShrinkingAlgorithm(FalsifiedSample originalSample, Consumer<FalsifiedSample> shrinkSampleConsumer, Consumer<FalsifiedSample> shrinkAttemptConsumer) {
        this.originalSample = originalSample;
        this.shrinkSampleConsumer = shrinkSampleConsumer;
        this.shrinkAttemptConsumer = shrinkAttemptConsumer;
    }

    FalsifiedSample shrink(Falsifier<List<Object>> falsifier) {
        FalsifiedSample before;
        FalsifiedSample after = this.originalSample;
        do {
            if (!(after = this.shrinkOneParameterAfterTheOther(falsifier, before = after, this.shrinkSampleConsumer, this.shrinkAttemptConsumer)).equals(before) || !(after = this.shrinkParametersPairwise(falsifier, after, this.shrinkSampleConsumer, this.shrinkAttemptConsumer)).equals(before)) continue;
            after = this.shrinkAndGrow(falsifier, after, this.shrinkSampleConsumer, this.shrinkAttemptConsumer);
        } while (!after.equals(before));
        return after;
    }

    private FalsifiedSample shrinkOneParameterAfterTheOther(Falsifier<List<Object>> falsifier, FalsifiedSample sample, Consumer<FalsifiedSample> shrinkSampleConsumer, Consumer<FalsifiedSample> shrinkAttemptConsumer) {
        return new OneAfterTheOtherParameterShrinker(this.falsificationCache).shrink(falsifier, sample, shrinkSampleConsumer, shrinkAttemptConsumer);
    }

    private FalsifiedSample shrinkParametersPairwise(Falsifier<List<Object>> falsifier, FalsifiedSample sample, Consumer<FalsifiedSample> shrinkSampleConsumer, Consumer<FalsifiedSample> shrinkAttemptConsumer) {
        return new PairwiseParameterShrinker(this.falsificationCache).shrink(falsifier, sample, shrinkSampleConsumer, shrinkAttemptConsumer);
    }

    private FalsifiedSample shrinkAndGrow(Falsifier<List<Object>> falsifier, FalsifiedSample sample, Consumer<FalsifiedSample> shrinkSampleConsumer, Consumer<FalsifiedSample> shrinkAttemptConsumer) {
        return new ShrinkAndGrowShrinker(this.falsificationCache).shrink(falsifier, sample, shrinkSampleConsumer, shrinkAttemptConsumer);
    }
}

