/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.stateful;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.jqwik.api.JqwikException;
import net.jqwik.api.Tuple;
import net.jqwik.api.stateful.Action;
import net.jqwik.api.stateful.ActionSequence;
import net.jqwik.api.stateful.Invariant;
import net.jqwik.engine.properties.stateful.ActionGenerator;
import net.jqwik.engine.properties.stateful.InvariantFailedError;
import net.jqwik.engine.support.JqwikStringSupport;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.TestAbortedException;

class SequentialActionSequence<M>
implements ActionSequence<M> {
    protected ActionGenerator<M> actionGenerator;
    protected int intendedSize;
    protected final List<Action<M>> sequence = new ArrayList<Action<M>>();
    private final List<Tuple.Tuple2<String, Invariant<M>>> invariants = new ArrayList<Tuple.Tuple2<String, Invariant<M>>>();
    private final List<Consumer<M>> peekers = new ArrayList<Consumer<M>>();
    protected ActionSequence.RunState runState = ActionSequence.RunState.NOT_RUN;
    private M currentModel = null;

    SequentialActionSequence(ActionGenerator<M> actionGenerator, int intendedSize) {
        if (intendedSize < 1) {
            throw new IllegalArgumentException("The intended size of an ActionSequence must not be 0");
        }
        this.actionGenerator = actionGenerator;
        this.intendedSize = intendedSize;
    }

    public synchronized List<Action<M>> runActions() {
        return this.sequence;
    }

    public synchronized M run(M model) {
        this.currentModel = model;
        if (this.runState == ActionSequence.RunState.NOT_RUN) {
            this.initialRun();
        } else {
            this.repeatedRun();
        }
        if (this.sequence.isEmpty()) {
            throw new JqwikException("Sequences without actions are invalid");
        }
        this.runState = ActionSequence.RunState.SUCCEEDED;
        return this.currentModel;
    }

    private void initialRun() {
        this.runState = ActionSequence.RunState.RUNNING;
        for (int i = 0; i < this.intendedSize; ++i) {
            Action<M> action;
            try {
                action = this.actionGenerator.next(this.currentModel);
            }
            catch (NoSuchElementException nsee) {
                break;
            }
            this.sequence.add(action);
            this.runAction(action);
        }
    }

    private void repeatedRun() {
        this.runState = ActionSequence.RunState.RUNNING;
        for (Action<M> action : new ArrayList<Action<M>>(this.sequence)) {
            if (action.precondition(this.currentModel)) {
                this.runAction(action);
                continue;
            }
            throw new TestAbortedException("Precondition violated on repeated run");
        }
    }

    private void runAction(Action<M> action) {
        try {
            this.currentModel = action.run(this.currentModel);
            this.callModelPeekers();
            this.checkInvariants();
        }
        catch (InvariantFailedError ife) {
            this.runState = ActionSequence.RunState.FAILED;
            throw ife;
        }
        catch (Throwable t) {
            this.runState = ActionSequence.RunState.FAILED;
            AssertionFailedError assertionFailedError = new AssertionFailedError(this.createErrorMessage("Run", t.getMessage()), t);
            assertionFailedError.setStackTrace(t.getStackTrace());
            throw assertionFailedError;
        }
    }

    private void callModelPeekers() {
        for (Consumer<M> peeker : this.peekers) {
            peeker.accept(this.currentModel);
        }
    }

    private void checkInvariants() {
        for (Tuple.Tuple2<String, Invariant<M>> tuple : this.invariants) {
            String label = (String)tuple.get1();
            Invariant invariant = (Invariant)tuple.get2();
            try {
                invariant.check(this.currentModel);
            }
            catch (Throwable t) {
                String invariantLabel = label == null ? "Invariant" : String.format("Invariant '%s'", label);
                throw new InvariantFailedError(this.createErrorMessage(invariantLabel, t.getMessage()), t);
            }
        }
    }

    private String createErrorMessage(String name, String causeMessage) {
        String actionsString = this.sequence.stream().map(aTry -> "    " + aTry.toString()).collect(Collectors.joining(System.lineSeparator()));
        return String.format("%s failed after following actions:%n%s%n  final currentModel: %s%n%s", name, actionsString, JqwikStringSupport.displayString(this.currentModel), causeMessage);
    }

    public synchronized ActionSequence<M> withInvariant(String label, Invariant<M> invariant) {
        this.invariants.add(Tuple.of((Object)label, invariant));
        return this;
    }

    public synchronized ActionSequence<M> peek(Consumer<M> modelPeeker) {
        this.peekers.add(modelPeeker);
        return this;
    }

    public ActionSequence.RunState runState() {
        return this.runState;
    }

    public int size() {
        if (this.runState == ActionSequence.RunState.NOT_RUN) {
            return this.intendedSize;
        }
        return this.actionGenerator.generated().size();
    }

    public synchronized M finalModel() {
        return this.currentModel;
    }

    public String toString() {
        if (this.runState == ActionSequence.RunState.NOT_RUN) {
            return String.format("ActionSequence[%s]: %s actions intended", this.runState.name(), this.intendedSize);
        }
        String actionsString = JqwikStringSupport.displayString(this.sequence);
        return String.format("ActionSequence[%s]: %s", this.runState.name(), actionsString);
    }
}

