/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.JqwikException;
import net.jqwik.api.Tuple;
import net.jqwik.api.domains.Domain;
import net.jqwik.api.domains.DomainContext;
import net.jqwik.api.lifecycle.PropertyLifecycleContext;
import net.jqwik.engine.descriptor.PropertyMethodDescriptor;
import net.jqwik.engine.execution.CombinedDomainContext;
import net.jqwik.engine.support.JqwikAnnotationSupport;
import net.jqwik.engine.support.JqwikReflectionSupport;

class DomainContextFactory {
    private final PropertyLifecycleContext propertyLifecycleContext;
    private final PropertyMethodDescriptor methodDescriptor;

    DomainContextFactory(PropertyLifecycleContext propertyLifecycleContext, PropertyMethodDescriptor methodDescriptor) {
        this.propertyLifecycleContext = propertyLifecycleContext;
        this.methodDescriptor = methodDescriptor;
    }

    DomainContext createCombinedDomainContext() {
        Set domainAnnotations = this.methodDescriptor.getDomains();
        if (domainAnnotations.isEmpty()) {
            return DomainContext.global();
        }
        Set<DomainContext> domainContexts = domainAnnotations.stream().flatMap(this::expandDomain).map(this::annotationToTuple).distinct().map(this::createDomainContext).peek(domainContext -> domainContext.initialize(this.propertyLifecycleContext)).collect(Collectors.toSet());
        return new CombinedDomainContext(domainContexts);
    }

    private Tuple.Tuple2<Class<? extends DomainContext>, Integer> annotationToTuple(Domain domain) {
        return Tuple.of((Object)domain.value(), (Object)domain.priority());
    }

    private Stream<Domain> expandDomain(Domain domain) {
        Stream inheritedDomains = JqwikAnnotationSupport.findContainerAnnotations(domain.value(), Domain.class).stream();
        return Stream.concat(Stream.of(domain), inheritedDomains);
    }

    private DomainContext createDomainContext(Tuple.Tuple2<Class<? extends DomainContext>, Integer> domainSpec) {
        Class domainContextClass = (Class)domainSpec.get1();
        int domainPriority = (Integer)domainSpec.get2();
        try {
            DomainContext domainContext = (DomainContext)JqwikReflectionSupport.newInstanceInTestContext(domainContextClass, this.propertyLifecycleContext.testInstance());
            if (domainPriority != Integer.MIN_VALUE) {
                domainContext.setDefaultPriority(domainPriority);
            }
            return domainContext;
        }
        catch (Throwable throwable) {
            String message = String.format("Cannot instantiate domain context @Domain(\"%s\") on [%s].", domainContextClass, this.methodDescriptor.getTargetMethod());
            throw new JqwikException(message);
        }
    }
}

