/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@FunctionalInterface
public interface FeatureExtractor<T>
extends Function<T, Object> {
    public static <T> FeatureExtractor<T> identity() {
        return t -> t;
    }

    default public Object applySafe(T t) {
        try {
            return this.apply(t);
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    default public boolean isUniqueIn(T value, Collection<T> elements) {
        Set elementFeatures = elements.stream().map(this::applySafe).collect(Collectors.toSet());
        return !elementFeatures.contains(this.applySafe(value));
    }

    default public boolean areUnique(Collection<T> elements) {
        Set elementFeatures = elements.stream().map(this::applySafe).collect(Collectors.toSet());
        return elementFeatures.size() == elements.size();
    }
}

