/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.jqwik.api.EdgeCasesMode;
import net.jqwik.api.GenerationMode;
import net.jqwik.api.SampleReportingFormat;
import net.jqwik.api.lifecycle.FalsifiedSample;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.api.lifecycle.ShrunkFalsifiedSample;
import net.jqwik.engine.execution.GenerationInfo;
import net.jqwik.engine.execution.lifecycle.ExtendedPropertyExecutionResult;
import net.jqwik.engine.execution.lifecycle.PlainExecutionResult;
import net.jqwik.engine.execution.reporting.SampleReportingFormats;
import net.jqwik.engine.execution.reporting.ValueReport;
import org.opentest4j.AssertionFailedError;

public class PropertyCheckResult
implements ExtendedPropertyExecutionResult {
    private final String stereotype;
    private final CheckStatus status;
    private final String propertyName;
    private final int tries;
    private final int checks;
    private final GenerationInfo generationInfo;
    private final GenerationMode generation;
    private final EdgeCasesMode edgeCasesMode;
    private final int edgeCasesTotal;
    private final int edgeCasesTried;
    private final FalsifiedSample originalSample;
    private final ShrunkFalsifiedSample shrunkSample;
    private final Throwable throwable;

    public static PropertyCheckResult successful(String stereotype, String propertyName, int tries, int checks, String randomSeed, GenerationMode generation, EdgeCasesMode edgeCasesMode, int edgeCasesTotal, int edgeCasesTried) {
        return new PropertyCheckResult(CheckStatus.SUCCESSFUL, stereotype, propertyName, tries, checks, new GenerationInfo(randomSeed), generation, edgeCasesMode, edgeCasesTotal, edgeCasesTried, null, null, null);
    }

    public static PropertyCheckResult failed(String stereotype, String propertyName, int tries, int checks, GenerationInfo generationInfo, GenerationMode generation, EdgeCasesMode edgeCasesMode, int edgeCasesTotal, int edgeCasesTried, FalsifiedSample originalSample, ShrunkFalsifiedSample shrunkSample, Throwable throwable) {
        if (shrunkSample != null && PropertyCheckResult.areEquivalent(originalSample, shrunkSample)) {
            shrunkSample = null;
        }
        return new PropertyCheckResult(CheckStatus.FAILED, stereotype, propertyName, tries, checks, generationInfo, generation, edgeCasesMode, edgeCasesTotal, edgeCasesTried, originalSample, shrunkSample, throwable);
    }

    private static boolean areEquivalent(FalsifiedSample originalSample, ShrunkFalsifiedSample shrunkSample) {
        return originalSample.equals(shrunkSample) && shrunkSample.countShrinkingSteps() == 0;
    }

    public static PropertyCheckResult skipExample(String stereotype, String propertyName, String randomSeed, GenerationMode generation, EdgeCasesMode edgeCasesMode, int edgeCasesTotal, int edgeCasesTried, Throwable throwable) {
        return new PropertyCheckResult(CheckStatus.ABORTED, stereotype, propertyName, 1, 0, new GenerationInfo(randomSeed), generation, edgeCasesMode, edgeCasesTotal, edgeCasesTried, null, null, throwable);
    }

    public static PropertyCheckResult exhausted(String stereotype, String propertyName, int tries, int checks, String randomSeed, GenerationMode generation, EdgeCasesMode edgeCasesMode, int edgeCasesTotal, int edgeCasesTried, Throwable throwable) {
        return new PropertyCheckResult(CheckStatus.EXHAUSTED, stereotype, propertyName, tries, checks, new GenerationInfo(randomSeed), generation, edgeCasesMode, edgeCasesTotal, edgeCasesTried, null, null, throwable);
    }

    private PropertyCheckResult(CheckStatus status, String stereotype, String propertyName, int tries, int checks, GenerationInfo generationInfo, GenerationMode generation, EdgeCasesMode edgeCasesMode, int edgeCasesTotal, int edgeCasesTried, FalsifiedSample originalSample, ShrunkFalsifiedSample shrunkSample, Throwable throwable) {
        this.stereotype = stereotype;
        this.status = status;
        this.propertyName = propertyName;
        this.tries = tries;
        this.checks = checks;
        this.generationInfo = generationInfo;
        this.generation = generation;
        this.edgeCasesMode = edgeCasesMode;
        this.edgeCasesTotal = edgeCasesTotal;
        this.edgeCasesTried = edgeCasesTried;
        this.shrunkSample = shrunkSample;
        this.originalSample = originalSample;
        this.throwable = this.determineThrowable(status, throwable);
    }

    private Throwable determineThrowable(CheckStatus status, Throwable throwable) {
        if (status == CheckStatus.SUCCESSFUL) {
            return null;
        }
        return throwable == null ? new AssertionFailedError(this.toString()) : throwable;
    }

    public Optional<List<Object>> falsifiedParameters() {
        if (this.shrunkSample != null) {
            return Optional.of(this.shrunkSample.parameters());
        }
        return Optional.ofNullable(this.originalSample).map(FalsifiedSample::parameters);
    }

    public PropertyExecutionResult.Status status() {
        switch (this.checkStatus()) {
            case SUCCESSFUL: {
                return PropertyExecutionResult.Status.SUCCESSFUL;
            }
            case ABORTED: {
                return PropertyExecutionResult.Status.ABORTED;
            }
        }
        return PropertyExecutionResult.Status.FAILED;
    }

    public Optional<Throwable> throwable() {
        return Optional.ofNullable(this.throwable);
    }

    public PropertyExecutionResult mapTo(PropertyExecutionResult.Status newStatus, Throwable throwable) {
        switch (newStatus) {
            case ABORTED: {
                return PlainExecutionResult.aborted(throwable, this.generationInfo);
            }
            case FAILED: {
                return new PropertyCheckResult(CheckStatus.FAILED, this.stereotype, this.propertyName, this.tries, this.checks, this.generationInfo, this.generation, this.edgeCasesMode, this.edgeCasesTotal, this.edgeCasesTried, this.originalSample, this.shrunkSample, throwable);
            }
            case SUCCESSFUL: {
                return new PropertyCheckResult(CheckStatus.SUCCESSFUL, this.stereotype, this.propertyName, this.tries, this.checks, this.generationInfo, this.generation, this.edgeCasesMode, this.edgeCasesTotal, this.edgeCasesTried, null, null, throwable);
            }
        }
        throw new IllegalStateException(String.format("Unknown state: %s", newStatus.name()));
    }

    @Override
    public boolean isExtended() {
        return true;
    }

    public String propertyName() {
        return this.propertyName;
    }

    public CheckStatus checkStatus() {
        return this.status;
    }

    public int countChecks() {
        return this.checks;
    }

    public int countTries() {
        return this.tries;
    }

    @Override
    public GenerationInfo generationInfo() {
        return this.generationInfo;
    }

    public Optional<FalsifiedSample> originalSample() {
        return Optional.ofNullable(this.originalSample);
    }

    public Optional<ShrunkFalsifiedSample> shrunkSample() {
        return Optional.ofNullable(this.shrunkSample);
    }

    @Override
    public GenerationMode generation() {
        return this.generation;
    }

    @Override
    public ExtendedPropertyExecutionResult.EdgeCasesExecutionResult edgeCases() {
        return new ExtendedPropertyExecutionResult.EdgeCasesExecutionResult(this.edgeCasesMode, this.edgeCasesTotal, this.edgeCasesTried);
    }

    public String toString() {
        String header = String.format("%s [%s]", this.stereotype, this.propertyName);
        switch (this.checkStatus()) {
            case FAILED: {
                String failedMessage = this.falsifiedParameters().map(sampleParams -> {
                    HashMap sampleMap = new HashMap();
                    for (int i = 0; i < sampleParams.size(); ++i) {
                        Object parameter = sampleParams.get(i);
                        sampleMap.put(i, parameter);
                    }
                    Collection<SampleReportingFormat> reportingFormats = SampleReportingFormats.getReportingFormats();
                    String sampleString = ValueReport.of(sampleMap, reportingFormats).singleLineReport();
                    return sampleParams.isEmpty() ? "" : String.format(" with sample %s", sampleString);
                }).orElse("");
                return String.format("%s failed%s", header, failedMessage);
            }
            case EXHAUSTED: {
                int rejections = this.tries - this.checks;
                return String.format("%s exhausted after [%d] tries and [%d] rejections", header, this.tries, rejections);
            }
        }
        return header;
    }

    static enum CheckStatus {
        SUCCESSFUL,
        FAILED,
        EXHAUSTED,
        ABORTED;

    }
}

