/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.providers.ArbitraryProvider;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.properties.DefaultArbitraries;

public class RegisteredArbitraryResolver {
    private final List<ArbitraryProvider> registeredProviders = new ArrayList<ArbitraryProvider>();

    public RegisteredArbitraryResolver(Collection<ArbitraryProvider> registeredProviders) {
        this.registeredProviders.addAll(registeredProviders);
        this.registeredProviders.addAll(DefaultArbitraries.getDefaultProviders());
    }

    public Set<Arbitrary<?>> resolve(TypeUsage targetType, ArbitraryProvider.SubtypeProvider subtypeProvider) {
        int currentPriority = Integer.MIN_VALUE;
        HashSet fittingArbitraries = new HashSet();
        for (ArbitraryProvider provider : this.registeredProviders) {
            if (!provider.canProvideFor(targetType) || provider.priority() < currentPriority) continue;
            if (provider.priority() > currentPriority) {
                fittingArbitraries.clear();
                currentPriority = provider.priority();
            }
            Set arbitraries = provider.provideFor(targetType, subtypeProvider);
            fittingArbitraries.addAll(arbitraries);
        }
        return fittingArbitraries;
    }
}

