/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.math.BigInteger;
import java.util.Optional;
import java.util.function.Consumer;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.arbitraries.BigIntegerArbitrary;
import net.jqwik.engine.properties.arbitraries.IntegralGeneratingArbitrary;
import net.jqwik.engine.properties.arbitraries.TypedCloneable;

public class DefaultBigIntegerArbitrary
extends TypedCloneable
implements BigIntegerArbitrary {
    public static final BigInteger DEFAULT_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    public static final BigInteger DEFAULT_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    private IntegralGeneratingArbitrary generatingArbitrary = new IntegralGeneratingArbitrary(DEFAULT_MIN, DEFAULT_MAX);

    public RandomGenerator<BigInteger> generator(int genSize) {
        return this.generatingArbitrary.generator(genSize);
    }

    public Optional<ExhaustiveGenerator<BigInteger>> exhaustive(long maxNumberOfSamples) {
        return this.generatingArbitrary.exhaustive(maxNumberOfSamples);
    }

    public EdgeCases<BigInteger> edgeCases(int maxEdgeCases) {
        return this.generatingArbitrary.edgeCases(maxEdgeCases);
    }

    public Arbitrary<BigInteger> edgeCases(Consumer<EdgeCases.Config<BigInteger>> configurator) {
        DefaultBigIntegerArbitrary clone = (DefaultBigIntegerArbitrary)this.typedClone();
        clone.generatingArbitrary = (IntegralGeneratingArbitrary)this.generatingArbitrary.edgeCases(configurator);
        return clone;
    }

    public BigIntegerArbitrary withDistribution(RandomDistribution distribution) {
        DefaultBigIntegerArbitrary clone = (DefaultBigIntegerArbitrary)this.typedClone();
        clone.generatingArbitrary.distribution = distribution;
        return clone;
    }

    public BigIntegerArbitrary greaterOrEqual(BigInteger min) {
        DefaultBigIntegerArbitrary clone = (DefaultBigIntegerArbitrary)this.typedClone();
        clone.generatingArbitrary.min = min == null ? DEFAULT_MIN : min;
        return clone;
    }

    public BigIntegerArbitrary lessOrEqual(BigInteger max) {
        DefaultBigIntegerArbitrary clone = (DefaultBigIntegerArbitrary)this.typedClone();
        clone.generatingArbitrary.max = max == null ? DEFAULT_MAX : max;
        return clone;
    }

    public BigIntegerArbitrary shrinkTowards(BigInteger target) {
        DefaultBigIntegerArbitrary clone = (DefaultBigIntegerArbitrary)this.typedClone();
        clone.generatingArbitrary.shrinkingTarget = target;
        return clone;
    }
}

