/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.math.BigInteger;
import java.util.Optional;
import java.util.function.Consumer;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.arbitraries.ByteArbitrary;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.IntegralGeneratingArbitrary;
import net.jqwik.engine.properties.arbitraries.MappedEdgeCasesConsumer;
import net.jqwik.engine.properties.arbitraries.TypedCloneable;

public class DefaultByteArbitrary
extends TypedCloneable
implements ByteArbitrary {
    private static final byte DEFAULT_MIN = -128;
    private static final byte DEFAULT_MAX = 127;
    private IntegralGeneratingArbitrary generatingArbitrary = new IntegralGeneratingArbitrary(BigInteger.valueOf(-128L), BigInteger.valueOf(127L));

    public RandomGenerator<Byte> generator(int genSize) {
        return this.generatingArbitrary.generator(genSize).map(BigInteger::byteValueExact);
    }

    public Optional<ExhaustiveGenerator<Byte>> exhaustive(long maxNumberOfSamples) {
        return this.generatingArbitrary.exhaustive(maxNumberOfSamples).map(generator -> generator.map(BigInteger::byteValueExact));
    }

    public EdgeCases<Byte> edgeCases(int maxEdgeCases) {
        return EdgeCasesSupport.map(this.generatingArbitrary.edgeCases(maxEdgeCases), BigInteger::byteValueExact);
    }

    public Arbitrary<Byte> edgeCases(Consumer<EdgeCases.Config<Byte>> configurator) {
        MappedEdgeCasesConsumer<Byte, BigInteger> integralConfigurator = new MappedEdgeCasesConsumer<Byte, BigInteger>(configurator, BigInteger::byteValueExact, BigInteger::valueOf);
        DefaultByteArbitrary clone = (DefaultByteArbitrary)this.typedClone();
        clone.generatingArbitrary = (IntegralGeneratingArbitrary)this.generatingArbitrary.edgeCases(integralConfigurator);
        return clone;
    }

    public ByteArbitrary withDistribution(RandomDistribution distribution) {
        DefaultByteArbitrary clone = (DefaultByteArbitrary)this.typedClone();
        clone.generatingArbitrary.distribution = distribution;
        return clone;
    }

    public ByteArbitrary greaterOrEqual(byte min) {
        DefaultByteArbitrary clone = (DefaultByteArbitrary)this.typedClone();
        clone.generatingArbitrary.min = BigInteger.valueOf(min);
        return clone;
    }

    public ByteArbitrary lessOrEqual(byte max) {
        DefaultByteArbitrary clone = (DefaultByteArbitrary)this.typedClone();
        clone.generatingArbitrary.max = BigInteger.valueOf(max);
        return clone;
    }

    public ByteArbitrary shrinkTowards(int target) {
        DefaultByteArbitrary clone = (DefaultByteArbitrary)this.typedClone();
        clone.generatingArbitrary.shrinkingTarget = BigInteger.valueOf(target);
        return clone;
    }
}

