/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.arbitraries.CharacterArbitrary;
import net.jqwik.api.arbitraries.StringArbitrary;
import net.jqwik.engine.properties.arbitraries.DefaultCharacterArbitrary;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.TypedCloneable;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;
import net.jqwik.engine.properties.shrinking.ShrinkableString;

public class DefaultStringArbitrary
extends TypedCloneable
implements StringArbitrary {
    private CharacterArbitrary characterArbitrary = new DefaultCharacterArbitrary();
    private int minLength = 0;
    private int maxLength = 255;
    private Set<Character> excludedChars = new HashSet<Character>();
    private RandomDistribution lengthDistribution = null;
    private double repeatChars = 0.0;

    public RandomGenerator<String> generator(int genSize) {
        return RandomGenerators.strings(this.randomCharacterGenerator(), this.minLength, this.maxLength, genSize, this.lengthDistribution);
    }

    public Optional<ExhaustiveGenerator<String>> exhaustive(long maxNumberOfSamples) {
        return ExhaustiveGenerators.strings(this.effectiveCharacterArbitrary(), this.minLength, this.maxLength, maxNumberOfSamples);
    }

    public EdgeCases<String> edgeCases(int maxEdgeCases) {
        if (maxEdgeCases <= 0) {
            return EdgeCases.none();
        }
        EdgeCases<String> emptyStringEdgeCases = this.hasEmptyStringEdgeCase() ? this.emptyStringEdgeCase() : EdgeCases.none();
        int effectiveMaxEdgeCases = maxEdgeCases - emptyStringEdgeCases.size();
        EdgeCases<String> singleCharEdgeCases = this.hasSingleCharEdgeCases() ? this.fixedSizedEdgeCases(1, effectiveMaxEdgeCases) : EdgeCases.none();
        EdgeCases<String> fixedSizeEdgeCases = this.hasMultiCharEdgeCases() ? this.fixedSizedEdgeCases(this.minLength, effectiveMaxEdgeCases -= singleCharEdgeCases.size()) : EdgeCases.none();
        return EdgeCasesSupport.concat(Arrays.asList(singleCharEdgeCases, emptyStringEdgeCases, fixedSizeEdgeCases), maxEdgeCases);
    }

    private boolean hasEmptyStringEdgeCase() {
        return this.minLength <= 0;
    }

    private boolean hasMultiCharEdgeCases() {
        return this.minLength <= this.maxLength && this.minLength > 1;
    }

    private boolean hasSingleCharEdgeCases() {
        return this.minLength <= 1 && this.maxLength >= 1;
    }

    private EdgeCases<String> emptyStringEdgeCase() {
        return EdgeCases.fromSupplier(() -> new ShrinkableString(Collections.emptyList(), this.minLength, this.maxLength));
    }

    private EdgeCases<String> fixedSizedEdgeCases(int fixedSize, int maxEdgeCases) {
        return EdgeCasesSupport.mapShrinkable(this.effectiveCharacterArbitrary().edgeCases(maxEdgeCases), shrinkableChar -> {
            ArrayList<Shrinkable<Character>> shrinkableChars = new ArrayList<Shrinkable<Character>>(Collections.nCopies(fixedSize, shrinkableChar));
            return new ShrinkableString(shrinkableChars, this.minLength, this.maxLength);
        });
    }

    public StringArbitrary ofMinLength(int minLength) {
        if (minLength < 0) {
            String message = String.format("minLength (%s) must be between 0 and 2147483647", minLength);
            throw new IllegalArgumentException(message);
        }
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.minLength = minLength;
        clone.maxLength = Math.max(this.maxLength, minLength);
        return clone;
    }

    public StringArbitrary ofMaxLength(int maxLength) {
        if (maxLength < 0) {
            String message = String.format("maxLength (%s) must be between 0 and 2147483647", maxLength);
            throw new IllegalArgumentException(message);
        }
        if (maxLength < this.minLength) {
            String message = String.format("minLength (%s) must not be larger than maxLength (%s)", this.minLength, maxLength);
            throw new IllegalArgumentException(message);
        }
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.maxLength = maxLength;
        return clone;
    }

    public StringArbitrary withLengthDistribution(RandomDistribution distribution) {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.lengthDistribution = distribution;
        return clone;
    }

    public StringArbitrary repeatChars(double repeatProbability) {
        if (repeatProbability < 0.0 || repeatProbability >= 1.0) {
            throw new IllegalArgumentException("repeatProbability must be between 0 (included) and 1 (excluded)");
        }
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.repeatChars = repeatProbability;
        return clone;
    }

    public StringArbitrary withChars(char ... chars) {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitrary = clone.characterArbitrary.with(chars);
        return clone;
    }

    public StringArbitrary withChars(CharSequence chars) {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitrary = clone.characterArbitrary.with(chars);
        return clone;
    }

    public StringArbitrary withCharRange(char from, char to) {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitrary = clone.characterArbitrary.range(from, to);
        return clone;
    }

    public StringArbitrary ascii() {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitrary = this.characterArbitrary.ascii();
        return clone;
    }

    public StringArbitrary alpha() {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitrary = clone.characterArbitrary.alpha();
        return clone;
    }

    public StringArbitrary numeric() {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitrary = clone.characterArbitrary.numeric();
        return clone;
    }

    public StringArbitrary whitespace() {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitrary = clone.characterArbitrary.whitespace();
        return clone;
    }

    public StringArbitrary all() {
        return this.withCharRange('\u0000', '\uffff');
    }

    public StringArbitrary excludeChars(char ... charsToExclude) {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        HashSet<Character> excludedChars = new HashSet<Character>(this.excludedChars);
        for (char c : charsToExclude) {
            excludedChars.add(Character.valueOf(c));
        }
        clone.excludedChars = excludedChars;
        return clone;
    }

    private RandomGenerator<Character> randomCharacterGenerator() {
        RandomGenerator characterGenerator = this.effectiveCharacterArbitrary().generator(1, false);
        if (this.repeatChars > 0.0) {
            return characterGenerator.injectDuplicates(this.repeatChars);
        }
        return characterGenerator;
    }

    private Arbitrary<Character> effectiveCharacterArbitrary() {
        CharacterArbitrary characterArbitrary = this.characterArbitrary;
        if (!this.excludedChars.isEmpty()) {
            characterArbitrary = characterArbitrary.filter(c -> !this.excludedChars.contains(c));
        }
        return characterArbitrary;
    }
}

