/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;

public class RecursiveArbitrary<T>
implements Arbitrary<T> {
    private final Supplier<Arbitrary<T>> base;
    private final Function<Arbitrary<T>, Arbitrary<T>> recur;
    private final int depth;
    private final Arbitrary<T> arbitrary;

    public RecursiveArbitrary(Supplier<Arbitrary<T>> base, Function<Arbitrary<T>, Arbitrary<T>> recur, int depth) {
        this.base = base;
        this.recur = recur;
        this.depth = depth;
        this.arbitrary = this.iteratedArbitrary();
    }

    public RandomGenerator<T> generator(int genSize) {
        return this.arbitrary.generator(genSize);
    }

    public EdgeCases<T> edgeCases(int maxEdgeCases) {
        if (this.depth > 100) {
            return EdgeCases.none();
        }
        return this.arbitrary.edgeCases(maxEdgeCases);
    }

    public Optional<ExhaustiveGenerator<T>> exhaustive(long maxNumberOfSamples) {
        Arbitrary<T> current = this.base.get();
        Optional last = current.exhaustive(maxNumberOfSamples);
        for (int i = 0; i < this.depth; ++i) {
            if (!last.isPresent()) {
                return Optional.empty();
            }
            current = this.recur.apply(current);
            last = current.exhaustive(maxNumberOfSamples);
        }
        return last;
    }

    private Arbitrary<T> iteratedArbitrary() {
        Arbitrary<T> current = this.base.get();
        for (int i = 0; i < this.depth; ++i) {
            current = this.recur.apply(current);
        }
        return current;
    }
}

