/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.TooManyFilterMissesException;
import net.jqwik.api.Tuple;
import net.jqwik.engine.properties.FeatureExtractor;
import net.jqwik.engine.properties.MaxTriesLoop;
import net.jqwik.engine.properties.UniquenessChecker;
import net.jqwik.engine.properties.arbitraries.randomized.SizeGenerator;

class ContainerGenerator<T, C>
implements RandomGenerator<C> {
    private final RandomGenerator<T> elementGenerator;
    private final Function<List<Shrinkable<T>>, Shrinkable<C>> createShrinkable;
    private final int minSize;
    private final int genSize;
    private final RandomDistribution sizeDistribution;
    private final Collection<FeatureExtractor<T>> uniquenessExtractors;
    private boolean noDuplicatesHadToBeSwitchedOff = false;
    private Function<Random, Integer> sizeGenerator;

    private static Function<Random, Integer> sizeGenerator(int minSize, int maxSize, int genSize, RandomDistribution sizeDistribution) {
        return SizeGenerator.create(minSize, maxSize, genSize, sizeDistribution);
    }

    ContainerGenerator(RandomGenerator<T> elementGenerator, Function<List<Shrinkable<T>>, Shrinkable<C>> createShrinkable, int minSize, int maxSize, int genSize, RandomDistribution sizeDistribution, Collection<FeatureExtractor<T>> uniquenessExtractors) {
        this.elementGenerator = elementGenerator;
        this.createShrinkable = createShrinkable;
        this.minSize = minSize;
        this.genSize = genSize;
        this.sizeDistribution = sizeDistribution;
        this.uniquenessExtractors = uniquenessExtractors;
        this.sizeGenerator = ContainerGenerator.sizeGenerator(minSize, maxSize, genSize, sizeDistribution);
    }

    public Shrinkable<C> next(Random random) {
        AbstractCollection existingValues;
        int listSize = this.sizeGenerator.apply(random);
        ArrayList listOfShrinkables = new ArrayList();
        boolean noDuplicates = !this.noDuplicatesHadToBeSwitchedOff && listSize >= 2 && this.uniquenessExtractors.isEmpty() && random.nextInt(100) <= 2;
        boolean canUseSetForValues = this.uniquenessExtractors.isEmpty() || this.uniquenessExtractors.contains(FeatureExtractor.identity());
        AbstractCollection abstractCollection = existingValues = canUseSetForValues ? new HashSet() : new ArrayList();
        while (listOfShrinkables.size() < listSize) {
            try {
                Shrinkable next = this.nextUntilAccepted(random, existingValues, arg_0 -> this.elementGenerator.next(arg_0), noDuplicates);
                listOfShrinkables.add(next);
            }
            catch (TooManyFilterMissesException tooManyFilterMissesException) {
                if (noDuplicates) {
                    noDuplicates = false;
                    this.noDuplicatesHadToBeSwitchedOff = true;
                    continue;
                }
                if (listOfShrinkables.size() < this.minSize) {
                    throw tooManyFilterMissesException;
                }
                listSize = listOfShrinkables.size();
                this.sizeGenerator = ContainerGenerator.sizeGenerator(this.minSize, listSize, this.genSize, this.sizeDistribution);
            }
        }
        return this.createShrinkable.apply(listOfShrinkables);
    }

    private Shrinkable<T> nextUntilAccepted(Random random, Collection<T> existingValues, Function<Random, Shrinkable<T>> fetchShrinkable, boolean noDuplicates) {
        return MaxTriesLoop.loop(() -> true, next -> {
            next = (Shrinkable)fetchShrinkable.apply(random);
            Object value = next.value();
            if (noDuplicates && existingValues.contains(value)) {
                return Tuple.of((Object)false, (Object)next);
            }
            if (!this.checkSpecifiedUniqueness(existingValues, value)) {
                return Tuple.of((Object)false, (Object)next);
            }
            existingValues.add(value);
            return Tuple.of((Object)true, (Object)next);
        }, maxMisses -> {
            String message = String.format("Trying to fulfill uniqueness constraint missed more than %s times.", maxMisses);
            return new TooManyFilterMissesException(message);
        }, 10000);
    }

    private boolean checkSpecifiedUniqueness(Collection<T> elements, T value) {
        return UniquenessChecker.checkValueUniqueIn(this.uniquenessExtractors, value, elements);
    }
}

