/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.util.Random;
import java.util.function.Function;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.TooManyFilterMissesException;
import net.jqwik.api.Tuple;
import net.jqwik.engine.properties.MaxTriesLoop;
import net.jqwik.engine.properties.shrinking.IgnoreExceptionShrinkable;

public class IgnoreExceptionGenerator<T>
implements RandomGenerator<T> {
    private final RandomGenerator<T> base;
    private final Class<? extends Throwable> exceptionType;

    public IgnoreExceptionGenerator(RandomGenerator<T> base, Class<? extends Throwable> exceptionType) {
        this.base = base;
        this.exceptionType = exceptionType;
    }

    public Shrinkable<T> next(Random random) {
        return new IgnoreExceptionShrinkable<T>(this.nextUntilAccepted(random, arg_0 -> this.base.next(arg_0)), this.exceptionType);
    }

    private Shrinkable<T> nextUntilAccepted(Random random, Function<Random, Shrinkable<T>> fetchShrinkable) {
        return MaxTriesLoop.loop(() -> true, next -> {
            try {
                next = (Shrinkable)fetchShrinkable.apply(random);
                next.value();
                return Tuple.of((Object)true, (Object)next);
            }
            catch (Throwable throwable) {
                if (this.exceptionType.isAssignableFrom(throwable.getClass())) {
                    return Tuple.of((Object)false, (Object)next);
                }
                throw throwable;
            }
        }, maxMisses -> {
            String message = String.format("%s missed more than %s times.", this.toString(), maxMisses);
            return new TooManyFilterMissesException(message);
        }, 10000);
    }
}

