/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.engine.support.JqwikStreamSupport;

public class CombinedShrinkable<T>
implements Shrinkable<T> {
    private final List<Shrinkable<Object>> parts;
    private final Function<List<Object>, T> combinator;

    public CombinedShrinkable(List<Shrinkable<Object>> parts, Function<List<Object>, T> combinator) {
        this.parts = parts;
        this.combinator = combinator;
    }

    public T value() {
        return this.createValue(this.parts);
    }

    private T createValue(List<Shrinkable<Object>> shrinkables) {
        return this.combinator.apply(this.createValues(shrinkables));
    }

    private List<Object> createValues(List<Shrinkable<Object>> shrinkables) {
        return shrinkables.stream().map(Shrinkable::value).collect(Collectors.toList());
    }

    public Stream<Shrinkable<T>> shrink() {
        return this.shrinkPartsOneAfterTheOther();
    }

    protected Stream<Shrinkable<T>> shrinkPartsOneAfterTheOther() {
        ArrayList shrinkPerPartStreams = new ArrayList();
        for (int i = 0; i < this.parts.size(); ++i) {
            int index = i;
            Shrinkable<Object> part = this.parts.get(i);
            Stream shrinkElement = part.shrink().flatMap(shrunkElement -> {
                ArrayList<Shrinkable<Object>> partsCopy = new ArrayList<Shrinkable<Object>>(this.parts);
                partsCopy.set(index, (Shrinkable<Object>)shrunkElement);
                return Stream.of(new CombinedShrinkable<T>(partsCopy, this.combinator));
            });
            shrinkPerPartStreams.add(shrinkElement);
        }
        return JqwikStreamSupport.concat(shrinkPerPartStreams);
    }

    public ShrinkingDistance distance() {
        return ShrinkingDistance.combine(this.parts);
    }
}

