/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.stream.Stream;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;

public class IgnoreExceptionShrinkable<T>
implements Shrinkable<T> {
    private final Shrinkable<T> shrinkable;
    private final Class<? extends Throwable> exceptionType;

    public IgnoreExceptionShrinkable(Shrinkable<T> shrinkable, Class<? extends Throwable> exceptionType) {
        this.shrinkable = shrinkable;
        this.exceptionType = exceptionType;
    }

    public T value() {
        return (T)this.shrinkable.value();
    }

    public Stream<Shrinkable<T>> shrink() {
        return this.shrinkable.shrink().filter(s -> {
            try {
                s.value();
                return true;
            }
            catch (Throwable throwable) {
                if (this.exceptionType.isAssignableFrom(throwable.getClass())) {
                    return false;
                }
                throw throwable;
            }
        }).map(shrinkable1 -> new IgnoreExceptionShrinkable<T>(shrinkable1, (Class<Throwable>)this.exceptionType));
    }

    public ShrinkingDistance distance() {
        return this.shrinkable.distance();
    }
}

