/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.providers;

import java.util.Set;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.constraints.WithNull;
import net.jqwik.api.providers.ArbitraryProvider;
import net.jqwik.api.providers.TypeUsage;

public class NullableArbitraryProvider
implements ArbitraryProvider {
    public boolean canProvideFor(TypeUsage targetType) {
        return targetType.isNullable() && !targetType.isAnnotated(WithNull.class);
    }

    public Set<Arbitrary<?>> provideFor(TypeUsage targetType, ArbitraryProvider.SubtypeProvider subtypeProvider) {
        TypeUsage nonNullType = targetType.asNotNullable();
        Set rawArbitraries = (Set)subtypeProvider.apply((Object)nonNullType);
        return rawArbitraries.stream().map(a -> a.injectNull(0.05)).collect(Collectors.toSet());
    }

    public int priority() {
        return 101;
    }
}

