/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.util.Random;
import java.util.function.Function;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.TooManyFilterMissesException;
import net.jqwik.engine.properties.shrinking.IgnoreExceptionShrinkable;

public class IgnoreExceptionGenerator<T>
implements RandomGenerator<T> {
    private final RandomGenerator<T> base;
    private final Class<? extends Throwable> exceptionType;

    public IgnoreExceptionGenerator(RandomGenerator<T> base, Class<? extends Throwable> exceptionType) {
        this.base = base;
        this.exceptionType = exceptionType;
    }

    public Shrinkable<T> next(Random random) {
        return new IgnoreExceptionShrinkable<T>(this.nextUntilAccepted(random, arg_0 -> this.base.next(arg_0)), this.exceptionType);
    }

    private Shrinkable<T> nextUntilAccepted(Random random, Function<Random, Shrinkable<T>> fetchShrinkable) {
        for (int i = 0; i < 10000; ++i) {
            try {
                Shrinkable<T> next = fetchShrinkable.apply(random);
                next.value();
                return next;
            }
            catch (Throwable throwable) {
                if (this.exceptionType.isInstance(throwable)) continue;
                throw throwable;
            }
        }
        String message = String.format("%s missed more than %s times.", this.toString(), 10000);
        throw new TooManyFilterMissesException(message);
    }
}

